<?php
/**
 * EmailJobStatus
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Model;

use \ArrayAccess;
use \ElasticEmail\ObjectSerializer;

/**
 * EmailJobStatus Class Doc Comment
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class EmailJobStatus implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'EmailJobStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'status' => 'string',
        'recipients_count' => 'int',
        'failed' => '\ElasticEmail\Model\EmailJobFailedStatus[]',
        'failed_count' => 'int',
        'sent' => 'string[]',
        'sent_count' => 'int',
        'delivered' => 'string[]',
        'delivered_count' => 'int',
        'pending' => 'string[]',
        'pending_count' => 'int',
        'opened' => 'string[]',
        'opened_count' => 'int',
        'clicked' => 'string[]',
        'clicked_count' => 'int',
        'unsubscribed' => 'string[]',
        'unsubscribed_count' => 'int',
        'abuse_reports' => 'string[]',
        'abuse_reports_count' => 'int',
        'message_ids' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'string',
        'status' => 'string',
        'recipients_count' => 'int32',
        'failed' => null,
        'failed_count' => 'int32',
        'sent' => 'string',
        'sent_count' => 'int32',
        'delivered' => 'string',
        'delivered_count' => 'int32',
        'pending' => 'string',
        'pending_count' => 'int32',
        'opened' => 'string',
        'opened_count' => 'int32',
        'clicked' => 'string',
        'clicked_count' => 'int32',
        'unsubscribed' => 'string',
        'unsubscribed_count' => 'int32',
        'abuse_reports' => 'string',
        'abuse_reports_count' => 'int32',
        'message_ids' => 'string'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'status' => false,
        'recipients_count' => false,
        'failed' => false,
        'failed_count' => false,
        'sent' => false,
        'sent_count' => false,
        'delivered' => false,
        'delivered_count' => false,
        'pending' => false,
        'pending_count' => false,
        'opened' => false,
        'opened_count' => false,
        'clicked' => false,
        'clicked_count' => false,
        'unsubscribed' => false,
        'unsubscribed_count' => false,
        'abuse_reports' => false,
        'abuse_reports_count' => false,
        'message_ids' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'ID',
        'status' => 'Status',
        'recipients_count' => 'RecipientsCount',
        'failed' => 'Failed',
        'failed_count' => 'FailedCount',
        'sent' => 'Sent',
        'sent_count' => 'SentCount',
        'delivered' => 'Delivered',
        'delivered_count' => 'DeliveredCount',
        'pending' => 'Pending',
        'pending_count' => 'PendingCount',
        'opened' => 'Opened',
        'opened_count' => 'OpenedCount',
        'clicked' => 'Clicked',
        'clicked_count' => 'ClickedCount',
        'unsubscribed' => 'Unsubscribed',
        'unsubscribed_count' => 'UnsubscribedCount',
        'abuse_reports' => 'AbuseReports',
        'abuse_reports_count' => 'AbuseReportsCount',
        'message_ids' => 'MessageIDs'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'status' => 'setStatus',
        'recipients_count' => 'setRecipientsCount',
        'failed' => 'setFailed',
        'failed_count' => 'setFailedCount',
        'sent' => 'setSent',
        'sent_count' => 'setSentCount',
        'delivered' => 'setDelivered',
        'delivered_count' => 'setDeliveredCount',
        'pending' => 'setPending',
        'pending_count' => 'setPendingCount',
        'opened' => 'setOpened',
        'opened_count' => 'setOpenedCount',
        'clicked' => 'setClicked',
        'clicked_count' => 'setClickedCount',
        'unsubscribed' => 'setUnsubscribed',
        'unsubscribed_count' => 'setUnsubscribedCount',
        'abuse_reports' => 'setAbuseReports',
        'abuse_reports_count' => 'setAbuseReportsCount',
        'message_ids' => 'setMessageIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'status' => 'getStatus',
        'recipients_count' => 'getRecipientsCount',
        'failed' => 'getFailed',
        'failed_count' => 'getFailedCount',
        'sent' => 'getSent',
        'sent_count' => 'getSentCount',
        'delivered' => 'getDelivered',
        'delivered_count' => 'getDeliveredCount',
        'pending' => 'getPending',
        'pending_count' => 'getPendingCount',
        'opened' => 'getOpened',
        'opened_count' => 'getOpenedCount',
        'clicked' => 'getClicked',
        'clicked_count' => 'getClickedCount',
        'unsubscribed' => 'getUnsubscribed',
        'unsubscribed_count' => 'getUnsubscribedCount',
        'abuse_reports' => 'getAbuseReports',
        'abuse_reports_count' => 'getAbuseReportsCount',
        'message_ids' => 'getMessageIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('recipients_count', $data ?? [], null);
        $this->setIfExists('failed', $data ?? [], null);
        $this->setIfExists('failed_count', $data ?? [], null);
        $this->setIfExists('sent', $data ?? [], null);
        $this->setIfExists('sent_count', $data ?? [], null);
        $this->setIfExists('delivered', $data ?? [], null);
        $this->setIfExists('delivered_count', $data ?? [], null);
        $this->setIfExists('pending', $data ?? [], null);
        $this->setIfExists('pending_count', $data ?? [], null);
        $this->setIfExists('opened', $data ?? [], null);
        $this->setIfExists('opened_count', $data ?? [], null);
        $this->setIfExists('clicked', $data ?? [], null);
        $this->setIfExists('clicked_count', $data ?? [], null);
        $this->setIfExists('unsubscribed', $data ?? [], null);
        $this->setIfExists('unsubscribed_count', $data ?? [], null);
        $this->setIfExists('abuse_reports', $data ?? [], null);
        $this->setIfExists('abuse_reports_count', $data ?? [], null);
        $this->setIfExists('message_ids', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id ID number of your attachment
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Name of status: submitted, complete, in_progress
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets recipients_count
     *
     * @return int|null
     */
    public function getRecipientsCount()
    {
        return $this->container['recipients_count'];
    }

    /**
     * Sets recipients_count
     *
     * @param int|null $recipients_count recipients_count
     *
     * @return self
     */
    public function setRecipientsCount($recipients_count)
    {
        if (is_null($recipients_count)) {
            throw new \InvalidArgumentException('non-nullable recipients_count cannot be null');
        }
        $this->container['recipients_count'] = $recipients_count;

        return $this;
    }

    /**
     * Gets failed
     *
     * @return \ElasticEmail\Model\EmailJobFailedStatus[]|null
     */
    public function getFailed()
    {
        return $this->container['failed'];
    }

    /**
     * Sets failed
     *
     * @param \ElasticEmail\Model\EmailJobFailedStatus[]|null $failed failed
     *
     * @return self
     */
    public function setFailed($failed)
    {
        if (is_null($failed)) {
            throw new \InvalidArgumentException('non-nullable failed cannot be null');
        }
        $this->container['failed'] = $failed;

        return $this;
    }

    /**
     * Gets failed_count
     *
     * @return int|null
     */
    public function getFailedCount()
    {
        return $this->container['failed_count'];
    }

    /**
     * Sets failed_count
     *
     * @param int|null $failed_count Total emails failed.
     *
     * @return self
     */
    public function setFailedCount($failed_count)
    {
        if (is_null($failed_count)) {
            throw new \InvalidArgumentException('non-nullable failed_count cannot be null');
        }
        $this->container['failed_count'] = $failed_count;

        return $this;
    }

    /**
     * Gets sent
     *
     * @return string[]|null
     */
    public function getSent()
    {
        return $this->container['sent'];
    }

    /**
     * Sets sent
     *
     * @param string[]|null $sent sent
     *
     * @return self
     */
    public function setSent($sent)
    {
        if (is_null($sent)) {
            throw new \InvalidArgumentException('non-nullable sent cannot be null');
        }
        $this->container['sent'] = $sent;

        return $this;
    }

    /**
     * Gets sent_count
     *
     * @return int|null
     */
    public function getSentCount()
    {
        return $this->container['sent_count'];
    }

    /**
     * Sets sent_count
     *
     * @param int|null $sent_count Total emails sent.
     *
     * @return self
     */
    public function setSentCount($sent_count)
    {
        if (is_null($sent_count)) {
            throw new \InvalidArgumentException('non-nullable sent_count cannot be null');
        }
        $this->container['sent_count'] = $sent_count;

        return $this;
    }

    /**
     * Gets delivered
     *
     * @return string[]|null
     */
    public function getDelivered()
    {
        return $this->container['delivered'];
    }

    /**
     * Sets delivered
     *
     * @param string[]|null $delivered Number of delivered messages
     *
     * @return self
     */
    public function setDelivered($delivered)
    {
        if (is_null($delivered)) {
            throw new \InvalidArgumentException('non-nullable delivered cannot be null');
        }
        $this->container['delivered'] = $delivered;

        return $this;
    }

    /**
     * Gets delivered_count
     *
     * @return int|null
     */
    public function getDeliveredCount()
    {
        return $this->container['delivered_count'];
    }

    /**
     * Sets delivered_count
     *
     * @param int|null $delivered_count delivered_count
     *
     * @return self
     */
    public function setDeliveredCount($delivered_count)
    {
        if (is_null($delivered_count)) {
            throw new \InvalidArgumentException('non-nullable delivered_count cannot be null');
        }
        $this->container['delivered_count'] = $delivered_count;

        return $this;
    }

    /**
     * Gets pending
     *
     * @return string[]|null
     */
    public function getPending()
    {
        return $this->container['pending'];
    }

    /**
     * Sets pending
     *
     * @param string[]|null $pending pending
     *
     * @return self
     */
    public function setPending($pending)
    {
        if (is_null($pending)) {
            throw new \InvalidArgumentException('non-nullable pending cannot be null');
        }
        $this->container['pending'] = $pending;

        return $this;
    }

    /**
     * Gets pending_count
     *
     * @return int|null
     */
    public function getPendingCount()
    {
        return $this->container['pending_count'];
    }

    /**
     * Sets pending_count
     *
     * @param int|null $pending_count pending_count
     *
     * @return self
     */
    public function setPendingCount($pending_count)
    {
        if (is_null($pending_count)) {
            throw new \InvalidArgumentException('non-nullable pending_count cannot be null');
        }
        $this->container['pending_count'] = $pending_count;

        return $this;
    }

    /**
     * Gets opened
     *
     * @return string[]|null
     */
    public function getOpened()
    {
        return $this->container['opened'];
    }

    /**
     * Sets opened
     *
     * @param string[]|null $opened Number of opened messages
     *
     * @return self
     */
    public function setOpened($opened)
    {
        if (is_null($opened)) {
            throw new \InvalidArgumentException('non-nullable opened cannot be null');
        }
        $this->container['opened'] = $opened;

        return $this;
    }

    /**
     * Gets opened_count
     *
     * @return int|null
     */
    public function getOpenedCount()
    {
        return $this->container['opened_count'];
    }

    /**
     * Sets opened_count
     *
     * @param int|null $opened_count Total emails opened.
     *
     * @return self
     */
    public function setOpenedCount($opened_count)
    {
        if (is_null($opened_count)) {
            throw new \InvalidArgumentException('non-nullable opened_count cannot be null');
        }
        $this->container['opened_count'] = $opened_count;

        return $this;
    }

    /**
     * Gets clicked
     *
     * @return string[]|null
     */
    public function getClicked()
    {
        return $this->container['clicked'];
    }

    /**
     * Sets clicked
     *
     * @param string[]|null $clicked Number of clicked messages
     *
     * @return self
     */
    public function setClicked($clicked)
    {
        if (is_null($clicked)) {
            throw new \InvalidArgumentException('non-nullable clicked cannot be null');
        }
        $this->container['clicked'] = $clicked;

        return $this;
    }

    /**
     * Gets clicked_count
     *
     * @return int|null
     */
    public function getClickedCount()
    {
        return $this->container['clicked_count'];
    }

    /**
     * Sets clicked_count
     *
     * @param int|null $clicked_count Total emails clicked
     *
     * @return self
     */
    public function setClickedCount($clicked_count)
    {
        if (is_null($clicked_count)) {
            throw new \InvalidArgumentException('non-nullable clicked_count cannot be null');
        }
        $this->container['clicked_count'] = $clicked_count;

        return $this;
    }

    /**
     * Gets unsubscribed
     *
     * @return string[]|null
     */
    public function getUnsubscribed()
    {
        return $this->container['unsubscribed'];
    }

    /**
     * Sets unsubscribed
     *
     * @param string[]|null $unsubscribed Number of unsubscribed messages
     *
     * @return self
     */
    public function setUnsubscribed($unsubscribed)
    {
        if (is_null($unsubscribed)) {
            throw new \InvalidArgumentException('non-nullable unsubscribed cannot be null');
        }
        $this->container['unsubscribed'] = $unsubscribed;

        return $this;
    }

    /**
     * Gets unsubscribed_count
     *
     * @return int|null
     */
    public function getUnsubscribedCount()
    {
        return $this->container['unsubscribed_count'];
    }

    /**
     * Sets unsubscribed_count
     *
     * @param int|null $unsubscribed_count Total emails unsubscribed
     *
     * @return self
     */
    public function setUnsubscribedCount($unsubscribed_count)
    {
        if (is_null($unsubscribed_count)) {
            throw new \InvalidArgumentException('non-nullable unsubscribed_count cannot be null');
        }
        $this->container['unsubscribed_count'] = $unsubscribed_count;

        return $this;
    }

    /**
     * Gets abuse_reports
     *
     * @return string[]|null
     */
    public function getAbuseReports()
    {
        return $this->container['abuse_reports'];
    }

    /**
     * Sets abuse_reports
     *
     * @param string[]|null $abuse_reports abuse_reports
     *
     * @return self
     */
    public function setAbuseReports($abuse_reports)
    {
        if (is_null($abuse_reports)) {
            throw new \InvalidArgumentException('non-nullable abuse_reports cannot be null');
        }
        $this->container['abuse_reports'] = $abuse_reports;

        return $this;
    }

    /**
     * Gets abuse_reports_count
     *
     * @return int|null
     */
    public function getAbuseReportsCount()
    {
        return $this->container['abuse_reports_count'];
    }

    /**
     * Sets abuse_reports_count
     *
     * @param int|null $abuse_reports_count abuse_reports_count
     *
     * @return self
     */
    public function setAbuseReportsCount($abuse_reports_count)
    {
        if (is_null($abuse_reports_count)) {
            throw new \InvalidArgumentException('non-nullable abuse_reports_count cannot be null');
        }
        $this->container['abuse_reports_count'] = $abuse_reports_count;

        return $this;
    }

    /**
     * Gets message_ids
     *
     * @return string[]|null
     */
    public function getMessageIds()
    {
        return $this->container['message_ids'];
    }

    /**
     * Sets message_ids
     *
     * @param string[]|null $message_ids List of all MessageIDs for this job.
     *
     * @return self
     */
    public function setMessageIds($message_ids)
    {
        if (is_null($message_ids)) {
            throw new \InvalidArgumentException('non-nullable message_ids cannot be null');
        }
        $this->container['message_ids'] = $message_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


