<?php

namespace garethp\ews\API\Message;

/**
 * Class representing BaseMoveCopyItemType
 *
 *
 * XSD Type: BaseMoveCopyItemType
 */
class BaseMoveCopyItemType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $toFolderId = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    protected $itemIds = null;

    /**
     * @var boolean
     */
    protected $returnNewItemIds = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TargetFolderIdType
     */
    public function getToFolderId()
    {
        return $this->toFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TargetFolderIdType
     * @return BaseMoveCopyItemType
     */
    public function setToFolderId(\garethp\ews\API\Type\TargetFolderIdType $value)
    {
        $this->toFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    public function getItemIds()
    {
        return $this->itemIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     * @return BaseMoveCopyItemType
     */
    public function setItemIds(\garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType $value)
    {
        $this->itemIds = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isReturnNewItemIds()
    {
        return ((bool) $this->returnNewItemIds);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getReturnNewItemIds()
    {
        return $this->returnNewItemIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BaseMoveCopyItemType
     */
    public function setReturnNewItemIds($value)
    {
        $this->returnNewItemIds = $value;
        return $this;
    }
}
