<?php

namespace garethp\ews\API\Message;

/**
 * Class representing ConvertIdResponseMessageType
 *
 * Response Message for a single id conversion in the ConvertId web method. Note
 *  that the AlternateId element will be missing in the case of an error.
 * XSD Type: ConvertIdResponseMessageType
 */
class ConvertIdResponseMessageType extends ResponseMessageType
{

    /**
     * @var \garethp\ews\API\Type\AlternateIdBaseType
     */
    protected $alternateId = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\AlternateIdBaseType
     */
    public function getAlternateId()
    {
        return $this->alternateId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\AlternateIdBaseType
     * @return ConvertIdResponseMessageType
     */
    public function setAlternateId(\garethp\ews\API\Type\AlternateIdBaseType $value)
    {
        $this->alternateId = $value;
        return $this;
    }
}
