<?php

namespace garethp\ews\API\Message;

/**
 * Class representing FindMessageTrackingReportResponseMessageType
 *
 *
 * XSD Type: FindMessageTrackingReportResponseMessageType
 */
class FindMessageTrackingReportResponseMessageType extends ResponseMessageType
{

    /**
     * @var string[]
     */
    protected $diagnostics = null;

    /**
     * @var \garethp\ews\API\Type\FindMessageTrackingSearchResultType[]
     */
    protected $messageTrackingSearchResults = null;

    /**
     * @var string
     */
    protected $executedSearchScope = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]
     */
    protected $errors = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function addDiagnostics($value)
    {
        if ($this->diagnostics === null) {
                        $this->diagnostics = array();
        }

        if (!is_array($this->diagnostics)) {
            $this->diagnostics = array($this->diagnostics);
        }

        $this->diagnostics[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getDiagnostics()
    {
        return $this->diagnostics;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function setDiagnostics(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->diagnostics = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FindMessageTrackingSearchResultType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function addMessageTrackingSearchResults(\garethp\ews\API\Type\FindMessageTrackingSearchResultType $value)
    {
        if ($this->messageTrackingSearchResults === null) {
                        $this->messageTrackingSearchResults = array();
        }

        if (!is_array($this->messageTrackingSearchResults)) {
            $this->messageTrackingSearchResults = array($this->messageTrackingSearchResults);
        }

        $this->messageTrackingSearchResults[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FindMessageTrackingSearchResultType[]
     */
    public function getMessageTrackingSearchResults()
    {
        return $this->messageTrackingSearchResults;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\FindMessageTrackingSearchResultType[]|\garethp\ews\API\Type\FindMessageTrackingSearchResultType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function setMessageTrackingSearchResults(array|\garethp\ews\API\Type\FindMessageTrackingSearchResultType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->messageTrackingSearchResults = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getExecutedSearchScope()
    {
        return $this->executedSearchScope;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function setExecutedSearchScope($value)
    {
        $this->executedSearchScope = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ArrayOfTrackingPropertiesType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function addErrors(\garethp\ews\API\Type\ArrayOfTrackingPropertiesType $value)
    {
        if ($this->errors === null) {
                        $this->errors = array();
        }

        if (!is_array($this->errors)) {
            $this->errors = array($this->errors);
        }

        $this->errors[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]|\garethp\ews\API\Type\ArrayOfTrackingPropertiesType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function setErrors(array|\garethp\ews\API\Type\ArrayOfTrackingPropertiesType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->errors = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TrackingPropertyType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function addProperties(\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if ($this->properties === null) {
                        $this->properties = array();
        }

        if (!is_array($this->properties)) {
            $this->properties = array($this->properties);
        }

        $this->properties[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TrackingPropertyType[]
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\TrackingPropertyType[]|\garethp\ews\API\Type\TrackingPropertyType
     * @return FindMessageTrackingReportResponseMessageType
     */
    public function setProperties(array|\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->properties = $value;
        return $this;
    }
}
