<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetUserAvailabilityRequestType
 *
 *
 * XSD Type: GetUserAvailabilityRequestType
 */
class GetUserAvailabilityRequestType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\TimeZone
     */
    protected $timeZone = null;

    /**
     * @var \garethp\ews\API\Type\MailboxDataType[]
     */
    protected $mailboxDataArray = null;

    /**
     * @var \garethp\ews\API\Type\FreeBusyViewOptions
     */
    protected $freeBusyViewOptions = null;

    /**
     * @var \garethp\ews\API\Type\SuggestionsViewOptions
     */
    protected $suggestionsViewOptions = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TimeZone
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\SerializableTimeZoneType
     * @return GetUserAvailabilityRequestType
     */
    public function setTimeZone(\garethp\ews\API\Type\SerializableTimeZoneType $value)
    {
        $this->timeZone = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\MailboxDataType
     * @return GetUserAvailabilityRequestType
     */
    public function addMailboxDataArray(\garethp\ews\API\Type\MailboxDataType $value)
    {
        if ($this->mailboxDataArray === null) {
                        $this->mailboxDataArray = array();
        }

        if (!is_array($this->mailboxDataArray)) {
            $this->mailboxDataArray = array($this->mailboxDataArray);
        }

        $this->mailboxDataArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\MailboxDataType[]
     */
    public function getMailboxDataArray()
    {
        return $this->mailboxDataArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\MailboxDataType[]|\garethp\ews\API\Type\MailboxDataType
     * @return GetUserAvailabilityRequestType
     */
    public function setMailboxDataArray(array|\garethp\ews\API\Type\MailboxDataType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->mailboxDataArray = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FreeBusyViewOptions
     */
    public function getFreeBusyViewOptions()
    {
        return $this->freeBusyViewOptions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FreeBusyViewOptionsType
     * @return GetUserAvailabilityRequestType
     */
    public function setFreeBusyViewOptions(\garethp\ews\API\Type\FreeBusyViewOptionsType $value)
    {
        $this->freeBusyViewOptions = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\SuggestionsViewOptions
     */
    public function getSuggestionsViewOptions()
    {
        return $this->suggestionsViewOptions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\SuggestionsViewOptionsType
     * @return GetUserAvailabilityRequestType
     */
    public function setSuggestionsViewOptions(\garethp\ews\API\Type\SuggestionsViewOptionsType $value)
    {
        $this->suggestionsViewOptions = $value;
        return $this;
    }
}
