<?php

namespace garethp\ews\API\Message;

/**
 * Class representing SendItemType
 *
 *
 * XSD Type: SendItemType
 */
class SendItemType extends BaseRequestType
{

    /**
     * @var boolean
     */
    protected $saveItemToFolder = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    protected $itemIds = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $savedItemFolderId = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isSaveItemToFolder()
    {
        return ((bool) $this->saveItemToFolder);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getSaveItemToFolder()
    {
        return $this->saveItemToFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return SendItemType
     */
    public function setSaveItemToFolder($value)
    {
        $this->saveItemToFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    public function getItemIds()
    {
        return $this->itemIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     * @return SendItemType
     */
    public function setItemIds(\garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType $value)
    {
        $this->itemIds = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TargetFolderIdType
     */
    public function getSavedItemFolderId()
    {
        return $this->savedItemFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TargetFolderIdType
     * @return SendItemType
     */
    public function setSavedItemFolderId(\garethp\ews\API\Type\TargetFolderIdType $value)
    {
        $this->savedItemFolderId = $value;
        return $this;
    }
}
