<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Message;

/**
 * Class representing SuggestionsResponseType
 *
 *
 * XSD Type: SuggestionsResponseType
 */
class SuggestionsResponseType extends Message
{

    /**
     * @var \garethp\ews\API\Message\ResponseMessageType
     */
    protected $responseMessage = null;

    /**
     * @var \garethp\ews\API\Type\SuggestionDayResultType[]
     */
    protected $suggestionDayResultArray = null;

    /**
     * @autogenerated This method is safe to replace
     * @return ResponseMessageType
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseMessageType
     * @return SuggestionsResponseType
     */
    public function setResponseMessage(ResponseMessageType $value)
    {
        $this->responseMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\SuggestionDayResultType
     * @return SuggestionsResponseType
     */
    public function addSuggestionDayResultArray(\garethp\ews\API\Type\SuggestionDayResultType $value)
    {
        if ($this->suggestionDayResultArray === null) {
                        $this->suggestionDayResultArray = array();
        }

        if (!is_array($this->suggestionDayResultArray)) {
            $this->suggestionDayResultArray = array($this->suggestionDayResultArray);
        }

        $this->suggestionDayResultArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\SuggestionDayResultType[]
     */
    public function getSuggestionDayResultArray()
    {
        return $this->suggestionDayResultArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\SuggestionDayResultType[]|\garethp\ews\API\Type\SuggestionDayResultType
     * @return SuggestionsResponseType
     */
    public function setSuggestionDayResultArray(array|\garethp\ews\API\Type\SuggestionDayResultType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->suggestionDayResultArray = $value;
        return $this;
    }
}
