<?php

namespace garethp\ews\API\Type;

use Countable;
use ArrayAccess;
use IteratorAggregate;
use garethp\ews\API\Type;

/**
 * Class representing ArrayOfRealItemsType
 *
 *
 * XSD Type: ArrayOfRealItemsType
 */
class ArrayOfRealItemsType extends Type implements Countable, ArrayAccess, IteratorAggregate
{

    /**
     * @var \garethp\ews\API\Type\ItemType[]
     */
    protected $item = null;

    /**
     * @var \garethp\ews\API\Type\MessageType[]
     */
    protected $message = null;

    /**
     * @var \garethp\ews\API\Type\CalendarItemType[]
     */
    protected $calendarItem = null;

    /**
     * @var \garethp\ews\API\Type\ContactItemType[]
     */
    protected $contact = null;

    /**
     * @var \garethp\ews\API\Type\DistributionListType[]
     */
    protected $distributionList = null;

    /**
     * @var \garethp\ews\API\Type\MeetingMessageType[]
     */
    protected $meetingMessage = null;

    /**
     * @var \garethp\ews\API\Type\MeetingRequestMessageType[]
     */
    protected $meetingRequest = null;

    /**
     * @var \garethp\ews\API\Type\MeetingResponseMessageType[]
     */
    protected $meetingResponse = null;

    /**
     * @var \garethp\ews\API\Type\MeetingCancellationMessageType[]
     */
    protected $meetingCancellation = null;

    /**
     * @var \garethp\ews\API\Type\TaskType[]
     */
    protected $task = null;

    /**
     * @var \garethp\ews\API\Type\PostItemType[]
     */
    protected $postItem = null;

    private $itemsArray = null;

    public function getItems()
    {
        if ($this->itemsArray) {
            return $this->itemsArray;
        }

        $items = array();

        foreach (get_object_vars($this) as $key => $value) {
            if ($key == "itemsArray" || substr($key, 0, 1) == "_" || $value === null) {
                continue;
            }

            if (!is_array($value)) {
                $value = array($value);
            }

            $items = array_merge($items, $value);
        }

        $this->itemsArray = $items;
        return $this->itemsArray;
    }

    public function count()
    {
        return count($this->getItems());
    }

    public function offsetExists($offset)
    {
        return isset($this->getItems()[$offset]);
    }

    public function offsetGet($offset)
    {
        $this->getItems();
        return isset($this->itemsArray[$offset]) ? $this->itemsArray[$offset] : null;
    }

    public function offsetSet($offset, $value)
    {
        $this->getItems();

        if (is_null($offset)) {
            $this->itemsArray[] = $value;
        } else {
            $this->itemsArray[$offset] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        $this->getItems();
        unset($this->itemsArray[$offset]);
    }

    public function getIterator()
    {
        $this->getItems();
        return new \ArrayIterator($this->itemsArray);
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemType
     * @return ArrayOfRealItemsType
     */
    public function addItem(ItemType $value)
    {
        if ($this->item === null) {
                        $this->item = array();
        }

        if (!is_array($this->item)) {
            $this->item = array($this->item);
        }

        $this->item[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemType[]
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemType[]|ItemType
     * @return ArrayOfRealItemsType
     */
    public function setItem(array|ItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->item = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MessageType
     * @return ArrayOfRealItemsType
     */
    public function addMessage(MessageType $value)
    {
        if ($this->message === null) {
                        $this->message = array();
        }

        if (!is_array($this->message)) {
            $this->message = array($this->message);
        }

        $this->message[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MessageType[]
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MessageType[]|MessageType
     * @return ArrayOfRealItemsType
     */
    public function setMessage(array|MessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->message = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarItemType
     * @return ArrayOfRealItemsType
     */
    public function addCalendarItem(CalendarItemType $value)
    {
        if ($this->calendarItem === null) {
                        $this->calendarItem = array();
        }

        if (!is_array($this->calendarItem)) {
            $this->calendarItem = array($this->calendarItem);
        }

        $this->calendarItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarItemType[]
     */
    public function getCalendarItem()
    {
        return $this->calendarItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarItemType[]|CalendarItemType
     * @return ArrayOfRealItemsType
     */
    public function setCalendarItem(array|CalendarItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->calendarItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactItemType
     * @return ArrayOfRealItemsType
     */
    public function addContact(ContactItemType $value)
    {
        if ($this->contact === null) {
                        $this->contact = array();
        }

        if (!is_array($this->contact)) {
            $this->contact = array($this->contact);
        }

        $this->contact[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ContactItemType[]
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactItemType[]|ContactItemType
     * @return ArrayOfRealItemsType
     */
    public function setContact(array|ContactItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->contact = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DistributionListType
     * @return ArrayOfRealItemsType
     */
    public function addDistributionList(DistributionListType $value)
    {
        if ($this->distributionList === null) {
                        $this->distributionList = array();
        }

        if (!is_array($this->distributionList)) {
            $this->distributionList = array($this->distributionList);
        }

        $this->distributionList[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DistributionListType[]
     */
    public function getDistributionList()
    {
        return $this->distributionList;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DistributionListType[]|DistributionListType
     * @return ArrayOfRealItemsType
     */
    public function setDistributionList(array|DistributionListType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->distributionList = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType
     * @return ArrayOfRealItemsType
     */
    public function addMeetingMessage(MeetingMessageType $value)
    {
        if ($this->meetingMessage === null) {
                        $this->meetingMessage = array();
        }

        if (!is_array($this->meetingMessage)) {
            $this->meetingMessage = array($this->meetingMessage);
        }

        $this->meetingMessage[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingMessageType[]
     */
    public function getMeetingMessage()
    {
        return $this->meetingMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return ArrayOfRealItemsType
     */
    public function setMeetingMessage(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingRequestMessageType
     * @return ArrayOfRealItemsType
     */
    public function addMeetingRequest(MeetingRequestMessageType $value)
    {
        if ($this->meetingRequest === null) {
                        $this->meetingRequest = array();
        }

        if (!is_array($this->meetingRequest)) {
            $this->meetingRequest = array($this->meetingRequest);
        }

        $this->meetingRequest[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingRequestMessageType[]
     */
    public function getMeetingRequest()
    {
        return $this->meetingRequest;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingRequestMessageType[]|MeetingRequestMessageType
     * @return ArrayOfRealItemsType
     */
    public function setMeetingRequest(array|MeetingRequestMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingRequest = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingResponseMessageType
     * @return ArrayOfRealItemsType
     */
    public function addMeetingResponse(MeetingResponseMessageType $value)
    {
        if ($this->meetingResponse === null) {
                        $this->meetingResponse = array();
        }

        if (!is_array($this->meetingResponse)) {
            $this->meetingResponse = array($this->meetingResponse);
        }

        $this->meetingResponse[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingResponseMessageType[]
     */
    public function getMeetingResponse()
    {
        return $this->meetingResponse;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return ArrayOfRealItemsType
     */
    public function setMeetingResponse(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingResponse = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingCancellationMessageType
     * @return ArrayOfRealItemsType
     */
    public function addMeetingCancellation(MeetingCancellationMessageType $value)
    {
        if ($this->meetingCancellation === null) {
                        $this->meetingCancellation = array();
        }

        if (!is_array($this->meetingCancellation)) {
            $this->meetingCancellation = array($this->meetingCancellation);
        }

        $this->meetingCancellation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingCancellationMessageType[]
     */
    public function getMeetingCancellation()
    {
        return $this->meetingCancellation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return ArrayOfRealItemsType
     */
    public function setMeetingCancellation(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingCancellation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TaskType
     * @return ArrayOfRealItemsType
     */
    public function addTask(TaskType $value)
    {
        if ($this->task === null) {
                        $this->task = array();
        }

        if (!is_array($this->task)) {
            $this->task = array($this->task);
        }

        $this->task[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TaskType[]
     */
    public function getTask()
    {
        return $this->task;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TaskType[]|TaskType
     * @return ArrayOfRealItemsType
     */
    public function setTask(array|TaskType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->task = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostItemType
     * @return ArrayOfRealItemsType
     */
    public function addPostItem(PostItemType $value)
    {
        if ($this->postItem === null) {
                        $this->postItem = array();
        }

        if (!is_array($this->postItem)) {
            $this->postItem = array($this->postItem);
        }

        $this->postItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PostItemType[]
     */
    public function getPostItem()
    {
        return $this->postItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostItemType[]|PostItemType
     * @return ArrayOfRealItemsType
     */
    public function setPostItem(array|PostItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->postItem = $value;
        return $this;
    }
}
