<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ArrayOfTrackingPropertiesType
 *
 *
 * XSD Type: ArrayOfTrackingPropertiesType
 */
class ArrayOfTrackingPropertiesType extends Type
{

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $trackingPropertyType = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType
     * @return ArrayOfTrackingPropertiesType
     */
    public function addTrackingPropertyType(TrackingPropertyType $value)
    {
        if ($this->trackingPropertyType === null) {
                        $this->trackingPropertyType = array();
        }

        if (!is_array($this->trackingPropertyType)) {
            $this->trackingPropertyType = array($this->trackingPropertyType);
        }

        $this->trackingPropertyType[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TrackingPropertyType[]
     */
    public function getTrackingPropertyType()
    {
        return $this->trackingPropertyType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType[]|TrackingPropertyType
     * @return ArrayOfTrackingPropertiesType
     */
    public function setTrackingPropertyType(array|TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->trackingPropertyType = $value;
        return $this;
    }
}
