<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing AttachmentType
 *
 *
 * XSD Type: AttachmentType
 */
class AttachmentType extends Type
{

    /**
     * @var \garethp\ews\API\Type\AttachmentIdType
     */
    protected $attachmentId = null;

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var string
     */
    protected $contentType = null;

    /**
     * @var string
     */
    protected $contentId = null;

    /**
     * @var string
     */
    protected $contentLocation = null;

    /**
     * @var integer
     */
    protected $size = null;

    /**
     * @var \DateTime
     */
    protected $lastModifiedTime = null;

    /**
     * @var boolean
     */
    protected $isInline = null;

    /**
     * @autogenerated This method is safe to replace
     * @return AttachmentIdType
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AttachmentIdType
     * @return AttachmentType
     */
    public function setAttachmentId(AttachmentIdType $value)
    {
        $this->attachmentId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttachmentType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContentType()
    {
        return $this->contentType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttachmentType
     */
    public function setContentType($value)
    {
        $this->contentType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContentId()
    {
        return $this->contentId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttachmentType
     */
    public function setContentId($value)
    {
        $this->contentId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContentLocation()
    {
        return $this->contentLocation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttachmentType
     */
    public function setContentLocation($value)
    {
        $this->contentLocation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return AttachmentType
     */
    public function setSize($value)
    {
        $this->size = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getLastModifiedTime()
    {
        return $this->lastModifiedTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return AttachmentType
     */
    public function setLastModifiedTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->lastModifiedTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isInline()
    {
        return ((bool) $this->isInline);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsInline()
    {
        return $this->isInline;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return AttachmentType
     */
    public function setIsInline($value)
    {
        $this->isInline = $value;
        return $this;
    }
}
