<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing CalendarEventDetailsType
 *
 *
 * XSD Type: CalendarEventDetails
 */
class CalendarEventDetailsType extends Type
{

    /**
     * @var string
     */
    protected $iD = null;

    /**
     * @var string
     */
    protected $subject = null;

    /**
     * @var string
     */
    protected $location = null;

    /**
     * @var boolean
     */
    protected $isMeeting = null;

    /**
     * @var boolean
     */
    protected $isRecurring = null;

    /**
     * @var boolean
     */
    protected $isException = null;

    /**
     * @var boolean
     */
    protected $isReminderSet = null;

    /**
     * @var boolean
     */
    protected $isPrivate = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getID()
    {
        return $this->iD;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return CalendarEventDetailsType
     */
    public function setID($value)
    {
        $this->iD = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return CalendarEventDetailsType
     */
    public function setSubject($value)
    {
        $this->subject = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return CalendarEventDetailsType
     */
    public function setLocation($value)
    {
        $this->location = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMeeting()
    {
        return ((bool) $this->isMeeting);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsMeeting()
    {
        return $this->isMeeting;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return CalendarEventDetailsType
     */
    public function setIsMeeting($value)
    {
        $this->isMeeting = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isRecurring()
    {
        return ((bool) $this->isRecurring);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsRecurring()
    {
        return $this->isRecurring;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return CalendarEventDetailsType
     */
    public function setIsRecurring($value)
    {
        $this->isRecurring = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isException()
    {
        return ((bool) $this->isException);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsException()
    {
        return $this->isException;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return CalendarEventDetailsType
     */
    public function setIsException($value)
    {
        $this->isException = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isReminderSet()
    {
        return ((bool) $this->isReminderSet);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsReminderSet()
    {
        return $this->isReminderSet;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return CalendarEventDetailsType
     */
    public function setIsReminderSet($value)
    {
        $this->isReminderSet = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isPrivate()
    {
        return ((bool) $this->isPrivate);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsPrivate()
    {
        return $this->isPrivate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return CalendarEventDetailsType
     */
    public function setIsPrivate($value)
    {
        $this->isPrivate = $value;
        return $this;
    }
}
