<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing CalendarPermissionSetType
 *
 * The set of permissions on a folder
 * XSD Type: CalendarPermissionSetType
 */
class CalendarPermissionSetType extends Type
{

    /**
     * @var \garethp\ews\API\Type\CalendarPermissionType[]
     */
    protected $calendarPermissions = null;

    /**
     * @var string[]
     */
    protected $unknownEntries = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarPermissionType
     * @return CalendarPermissionSetType
     */
    public function addCalendarPermissions(CalendarPermissionType $value)
    {
        if ($this->calendarPermissions === null) {
                        $this->calendarPermissions = array();
        }

        if (!is_array($this->calendarPermissions)) {
            $this->calendarPermissions = array($this->calendarPermissions);
        }

        $this->calendarPermissions[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarPermissionType[]
     */
    public function getCalendarPermissions()
    {
        return $this->calendarPermissions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarPermissionType[]|CalendarPermissionType
     * @return CalendarPermissionSetType
     */
    public function setCalendarPermissions(array|CalendarPermissionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->calendarPermissions = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return CalendarPermissionSetType
     */
    public function addUnknownEntries($value)
    {
        if ($this->unknownEntries === null) {
                        $this->unknownEntries = array();
        }

        if (!is_array($this->unknownEntries)) {
            $this->unknownEntries = array($this->unknownEntries);
        }

        $this->unknownEntries[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUnknownEntries()
    {
        return $this->unknownEntries;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return CalendarPermissionSetType
     */
    public function setUnknownEntries(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->unknownEntries = $value;
        return $this;
    }
}
