<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing DelegateUserType
 *
 *
 * XSD Type: DelegateUserType
 */
class DelegateUserType extends Type
{

    /**
     * @var \garethp\ews\API\Type\UserIdType
     */
    protected $userId = null;

    /**
     * @var \garethp\ews\API\Type\DelegatePermissionsType
     */
    protected $delegatePermissions = null;

    /**
     * @var boolean
     */
    protected $receiveCopiesOfMeetingMessages = null;

    /**
     * @var boolean
     */
    protected $viewPrivateItems = null;

    /**
     * @autogenerated This method is safe to replace
     * @return UserIdType
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value UserIdType
     * @return DelegateUserType
     */
    public function setUserId(UserIdType $value)
    {
        $this->userId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DelegatePermissionsType
     */
    public function getDelegatePermissions()
    {
        return $this->delegatePermissions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DelegatePermissionsType
     * @return DelegateUserType
     */
    public function setDelegatePermissions(DelegatePermissionsType $value)
    {
        $this->delegatePermissions = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isReceiveCopiesOfMeetingMessages()
    {
        return ((bool) $this->receiveCopiesOfMeetingMessages);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getReceiveCopiesOfMeetingMessages()
    {
        return $this->receiveCopiesOfMeetingMessages;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return DelegateUserType
     */
    public function setReceiveCopiesOfMeetingMessages($value)
    {
        $this->receiveCopiesOfMeetingMessages = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isViewPrivateItems()
    {
        return ((bool) $this->viewPrivateItems);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getViewPrivateItems()
    {
        return $this->viewPrivateItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return DelegateUserType
     */
    public function setViewPrivateItems($value)
    {
        $this->viewPrivateItems = $value;
        return $this;
    }
}
