<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing FreeBusyViewType
 *
 *
 * XSD Type: FreeBusyView
 */
class FreeBusyViewType extends Type
{

    /**
     * @var string[]
     */
    protected $freeBusyViewType = null;

    /**
     * @var string
     */
    protected $mergedFreeBusy = null;

    /**
     * @var \garethp\ews\API\Type\CalendarEventType[]
     */
    protected $calendarEventArray = null;

    /**
     * @var \garethp\ews\API\Type\WorkingHoursType
     */
    protected $workingHours = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FreeBusyViewType
     */
    public function addFreeBusyViewType($value)
    {
        if ($this->freeBusyViewType === null) {
                        $this->freeBusyViewType = array();
        }

        if (!is_array($this->freeBusyViewType)) {
            $this->freeBusyViewType = array($this->freeBusyViewType);
        }

        $this->freeBusyViewType[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getFreeBusyViewType()
    {
        return $this->freeBusyViewType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FreeBusyViewType
     */
    public function setFreeBusyViewType(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->freeBusyViewType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMergedFreeBusy()
    {
        return $this->mergedFreeBusy;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FreeBusyViewType
     */
    public function setMergedFreeBusy($value)
    {
        $this->mergedFreeBusy = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarEventType
     * @return FreeBusyViewType
     */
    public function addCalendarEventArray(CalendarEventType $value)
    {
        if ($this->calendarEventArray === null) {
                        $this->calendarEventArray = array();
        }

        if (!is_array($this->calendarEventArray)) {
            $this->calendarEventArray = array($this->calendarEventArray);
        }

        $this->calendarEventArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarEventType[]
     */
    public function getCalendarEventArray()
    {
        return $this->calendarEventArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarEventType[]|CalendarEventType
     * @return FreeBusyViewType
     */
    public function setCalendarEventArray(array|CalendarEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->calendarEventArray = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return WorkingHoursType
     */
    public function getWorkingHours()
    {
        return $this->workingHours;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value WorkingHoursType
     * @return FreeBusyViewType
     */
    public function setWorkingHours(WorkingHoursType $value)
    {
        $this->workingHours = $value;
        return $this;
    }
}
