<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ItemChangeType
 *
 *
 * XSD Type: ItemChangeType
 */
class ItemChangeType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $itemId = null;

    /**
     * @var \garethp\ews\API\Type\OccurrenceItemIdType
     */
    protected $occurrenceItemId = null;

    /**
     * @var \garethp\ews\API\Type\RecurringMasterItemIdType
     */
    protected $recurringMasterItemId = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfItemChangeDescriptionsType
     */
    protected $updates = null;

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return ItemChangeType
     */
    public function setItemId(ItemIdType $value)
    {
        $this->itemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return OccurrenceItemIdType
     */
    public function getOccurrenceItemId()
    {
        return $this->occurrenceItemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value OccurrenceItemIdType
     * @return ItemChangeType
     */
    public function setOccurrenceItemId(OccurrenceItemIdType $value)
    {
        $this->occurrenceItemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RecurringMasterItemIdType
     */
    public function getRecurringMasterItemId()
    {
        return $this->recurringMasterItemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringMasterItemIdType
     * @return ItemChangeType
     */
    public function setRecurringMasterItemId(RecurringMasterItemIdType $value)
    {
        $this->recurringMasterItemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfItemChangeDescriptionsType
     */
    public function getUpdates()
    {
        return $this->updates;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfItemChangeDescriptionsType
     * @return ItemChangeType
     */
    public function setUpdates(NonEmptyArrayOfItemChangeDescriptionsType $value)
    {
        $this->updates = $value;
        return $this;
    }
}
