<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ManagedFolderInformationType
 *
 * Compound property for Managed Folder related information for Managed Folders.
 * XSD Type: ManagedFolderInformationType
 */
class ManagedFolderInformationType extends Type
{

    /**
     * @var boolean
     */
    protected $canDelete = null;

    /**
     * @var boolean
     */
    protected $canRenameOrMove = null;

    /**
     * @var boolean
     */
    protected $mustDisplayComment = null;

    /**
     * @var boolean
     */
    protected $hasQuota = null;

    /**
     * @var boolean
     */
    protected $isManagedFoldersRoot = null;

    /**
     * @var string
     */
    protected $managedFolderId = null;

    /**
     * @var string
     */
    protected $comment = null;

    /**
     * @var integer
     */
    protected $storageQuota = null;

    /**
     * @var integer
     */
    protected $folderSize = null;

    /**
     * @var string
     */
    protected $homePage = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isCanDelete()
    {
        return ((bool) $this->canDelete);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getCanDelete()
    {
        return $this->canDelete;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ManagedFolderInformationType
     */
    public function setCanDelete($value)
    {
        $this->canDelete = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isCanRenameOrMove()
    {
        return ((bool) $this->canRenameOrMove);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getCanRenameOrMove()
    {
        return $this->canRenameOrMove;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ManagedFolderInformationType
     */
    public function setCanRenameOrMove($value)
    {
        $this->canRenameOrMove = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMustDisplayComment()
    {
        return ((bool) $this->mustDisplayComment);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getMustDisplayComment()
    {
        return $this->mustDisplayComment;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ManagedFolderInformationType
     */
    public function setMustDisplayComment($value)
    {
        $this->mustDisplayComment = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isHasQuota()
    {
        return ((bool) $this->hasQuota);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getHasQuota()
    {
        return $this->hasQuota;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ManagedFolderInformationType
     */
    public function setHasQuota($value)
    {
        $this->hasQuota = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isManagedFoldersRoot()
    {
        return ((bool) $this->isManagedFoldersRoot);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsManagedFoldersRoot()
    {
        return $this->isManagedFoldersRoot;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ManagedFolderInformationType
     */
    public function setIsManagedFoldersRoot($value)
    {
        $this->isManagedFoldersRoot = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getManagedFolderId()
    {
        return $this->managedFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ManagedFolderInformationType
     */
    public function setManagedFolderId($value)
    {
        $this->managedFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ManagedFolderInformationType
     */
    public function setComment($value)
    {
        $this->comment = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getStorageQuota()
    {
        return $this->storageQuota;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ManagedFolderInformationType
     */
    public function setStorageQuota($value)
    {
        $this->storageQuota = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getFolderSize()
    {
        return $this->folderSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ManagedFolderInformationType
     */
    public function setFolderSize($value)
    {
        $this->folderSize = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getHomePage()
    {
        return $this->homePage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ManagedFolderInformationType
     */
    public function setHomePage($value)
    {
        $this->homePage = $value;
        return $this;
    }
}
