<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing MemberType
 *
 *
 * XSD Type: MemberType
 */
class MemberType extends Type
{

    /**
     * @var string
     */
    protected $key = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $mailbox = null;

    /**
     * @var string
     */
    protected $status = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MemberType
     */
    public function setKey($value)
    {
        $this->key = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getMailbox()
    {
        return $this->mailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MemberType
     */
    public function setMailbox(EmailAddressType $value)
    {
        $this->mailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MemberType
     */
    public function setStatus($value)
    {
        $this->status = $value;
        return $this;
    }
}
