<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing MessageTrackingReportType
 *
 *
 * XSD Type: MessageTrackingReportType
 */
class MessageTrackingReportType extends Type
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $sender = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $purportedSender = null;

    /**
     * @var string
     */
    protected $subject = null;

    /**
     * @var \DateTime
     */
    protected $submitTime = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $originalRecipients = null;

    /**
     * @var \garethp\ews\API\Type\RecipientTrackingEventType[]
     */
    protected $recipientTrackingEvents = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MessageTrackingReportType
     */
    public function setSender(EmailAddressType $value)
    {
        $this->sender = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getPurportedSender()
    {
        return $this->purportedSender;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MessageTrackingReportType
     */
    public function setPurportedSender(EmailAddressType $value)
    {
        $this->purportedSender = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MessageTrackingReportType
     */
    public function setSubject($value)
    {
        $this->subject = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getSubmitTime()
    {
        return $this->submitTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return MessageTrackingReportType
     */
    public function setSubmitTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->submitTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MessageTrackingReportType
     */
    public function addOriginalRecipients(EmailAddressType $value)
    {
        if ($this->originalRecipients === null) {
                        $this->originalRecipients = array();
        }

        if (!is_array($this->originalRecipients)) {
            $this->originalRecipients = array($this->originalRecipients);
        }

        $this->originalRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getOriginalRecipients()
    {
        return $this->originalRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return MessageTrackingReportType
     */
    public function setOriginalRecipients(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->originalRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecipientTrackingEventType
     * @return MessageTrackingReportType
     */
    public function addRecipientTrackingEvents(RecipientTrackingEventType $value)
    {
        if ($this->recipientTrackingEvents === null) {
                        $this->recipientTrackingEvents = array();
        }

        if (!is_array($this->recipientTrackingEvents)) {
            $this->recipientTrackingEvents = array($this->recipientTrackingEvents);
        }

        $this->recipientTrackingEvents[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RecipientTrackingEventType[]
     */
    public function getRecipientTrackingEvents()
    {
        return $this->recipientTrackingEvents;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecipientTrackingEventType[]|RecipientTrackingEventType
     * @return MessageTrackingReportType
     */
    public function setRecipientTrackingEvents(array|RecipientTrackingEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recipientTrackingEvents = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType
     * @return MessageTrackingReportType
     */
    public function addProperties(TrackingPropertyType $value)
    {
        if ($this->properties === null) {
                        $this->properties = array();
        }

        if (!is_array($this->properties)) {
            $this->properties = array($this->properties);
        }

        $this->properties[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TrackingPropertyType[]
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType[]|TrackingPropertyType
     * @return MessageTrackingReportType
     */
    public function setProperties(array|TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->properties = $value;
        return $this;
    }
}
