<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NotificationType
 *
 *
 * XSD Type: NotificationType
 */
class NotificationType extends Type
{

    /**
     * @var string
     */
    protected $subscriptionId = null;

    /**
     * @var string
     */
    protected $previousWatermark = null;

    /**
     * @var boolean
     */
    protected $moreEvents = null;

    /**
     * @var \garethp\ews\API\Type\MovedCopiedEventType[]
     */
    protected $copiedEvent = null;

    /**
     * @var \garethp\ews\API\Type\BaseObjectChangedEventType[]
     */
    protected $createdEvent = null;

    /**
     * @var \garethp\ews\API\Type\BaseObjectChangedEventType[]
     */
    protected $deletedEvent = null;

    /**
     * @var \garethp\ews\API\Type\ModifiedEventType[]
     */
    protected $modifiedEvent = null;

    /**
     * @var \garethp\ews\API\Type\MovedCopiedEventType[]
     */
    protected $movedEvent = null;

    /**
     * @var \garethp\ews\API\Type\BaseObjectChangedEventType[]
     */
    protected $newMailEvent = null;

    /**
     * @var \garethp\ews\API\Type\BaseNotificationEventType[]
     */
    protected $statusEvent = null;

    /**
     * @var \garethp\ews\API\Type\BaseObjectChangedEventType[]
     */
    protected $freeBusyChangedEvent = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return NotificationType
     */
    public function setSubscriptionId($value)
    {
        $this->subscriptionId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPreviousWatermark()
    {
        return $this->previousWatermark;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return NotificationType
     */
    public function setPreviousWatermark($value)
    {
        $this->previousWatermark = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMoreEvents()
    {
        return ((bool) $this->moreEvents);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getMoreEvents()
    {
        return $this->moreEvents;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return NotificationType
     */
    public function setMoreEvents($value)
    {
        $this->moreEvents = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MovedCopiedEventType
     * @return NotificationType
     */
    public function addCopiedEvent(MovedCopiedEventType $value)
    {
        if ($this->copiedEvent === null) {
                        $this->copiedEvent = array();
        }

        if (!is_array($this->copiedEvent)) {
            $this->copiedEvent = array($this->copiedEvent);
        }

        $this->copiedEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MovedCopiedEventType[]
     */
    public function getCopiedEvent()
    {
        return $this->copiedEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MovedCopiedEventType[]|MovedCopiedEventType
     * @return NotificationType
     */
    public function setCopiedEvent(array|MovedCopiedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->copiedEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType
     * @return NotificationType
     */
    public function addCreatedEvent(BaseObjectChangedEventType $value)
    {
        if ($this->createdEvent === null) {
                        $this->createdEvent = array();
        }

        if (!is_array($this->createdEvent)) {
            $this->createdEvent = array($this->createdEvent);
        }

        $this->createdEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return BaseObjectChangedEventType[]
     */
    public function getCreatedEvent()
    {
        return $this->createdEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType[]|BaseObjectChangedEventType
     * @return NotificationType
     */
    public function setCreatedEvent(array|BaseObjectChangedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->createdEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType
     * @return NotificationType
     */
    public function addDeletedEvent(BaseObjectChangedEventType $value)
    {
        if ($this->deletedEvent === null) {
                        $this->deletedEvent = array();
        }

        if (!is_array($this->deletedEvent)) {
            $this->deletedEvent = array($this->deletedEvent);
        }

        $this->deletedEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return BaseObjectChangedEventType[]
     */
    public function getDeletedEvent()
    {
        return $this->deletedEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType[]|BaseObjectChangedEventType
     * @return NotificationType
     */
    public function setDeletedEvent(array|BaseObjectChangedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->deletedEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ModifiedEventType
     * @return NotificationType
     */
    public function addModifiedEvent(ModifiedEventType $value)
    {
        if ($this->modifiedEvent === null) {
                        $this->modifiedEvent = array();
        }

        if (!is_array($this->modifiedEvent)) {
            $this->modifiedEvent = array($this->modifiedEvent);
        }

        $this->modifiedEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ModifiedEventType[]
     */
    public function getModifiedEvent()
    {
        return $this->modifiedEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ModifiedEventType[]|ModifiedEventType
     * @return NotificationType
     */
    public function setModifiedEvent(array|ModifiedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->modifiedEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MovedCopiedEventType
     * @return NotificationType
     */
    public function addMovedEvent(MovedCopiedEventType $value)
    {
        if ($this->movedEvent === null) {
                        $this->movedEvent = array();
        }

        if (!is_array($this->movedEvent)) {
            $this->movedEvent = array($this->movedEvent);
        }

        $this->movedEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MovedCopiedEventType[]
     */
    public function getMovedEvent()
    {
        return $this->movedEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MovedCopiedEventType[]|MovedCopiedEventType
     * @return NotificationType
     */
    public function setMovedEvent(array|MovedCopiedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->movedEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType
     * @return NotificationType
     */
    public function addNewMailEvent(BaseObjectChangedEventType $value)
    {
        if ($this->newMailEvent === null) {
                        $this->newMailEvent = array();
        }

        if (!is_array($this->newMailEvent)) {
            $this->newMailEvent = array($this->newMailEvent);
        }

        $this->newMailEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return BaseObjectChangedEventType[]
     */
    public function getNewMailEvent()
    {
        return $this->newMailEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType[]|BaseObjectChangedEventType
     * @return NotificationType
     */
    public function setNewMailEvent(array|BaseObjectChangedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->newMailEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseNotificationEventType
     * @return NotificationType
     */
    public function addStatusEvent(BaseNotificationEventType $value)
    {
        if ($this->statusEvent === null) {
                        $this->statusEvent = array();
        }

        if (!is_array($this->statusEvent)) {
            $this->statusEvent = array($this->statusEvent);
        }

        $this->statusEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return BaseNotificationEventType[]
     */
    public function getStatusEvent()
    {
        return $this->statusEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseNotificationEventType[]|BaseNotificationEventType
     * @return NotificationType
     */
    public function setStatusEvent(array|BaseNotificationEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->statusEvent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType
     * @return NotificationType
     */
    public function addFreeBusyChangedEvent(BaseObjectChangedEventType $value)
    {
        if ($this->freeBusyChangedEvent === null) {
                        $this->freeBusyChangedEvent = array();
        }

        if (!is_array($this->freeBusyChangedEvent)) {
            $this->freeBusyChangedEvent = array($this->freeBusyChangedEvent);
        }

        $this->freeBusyChangedEvent[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return BaseObjectChangedEventType[]
     */
    public function getFreeBusyChangedEvent()
    {
        return $this->freeBusyChangedEvent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value BaseObjectChangedEventType[]|BaseObjectChangedEventType
     * @return NotificationType
     */
    public function setFreeBusyChangedEvent(array|BaseObjectChangedEventType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->freeBusyChangedEvent = $value;
        return $this;
    }
}
