<?php

namespace garethp\ews\API\Type;

/**
 * Class representing PermissionType
 *
 * A permission on a folder
 * XSD Type: PermissionType
 */
class PermissionType extends BasePermissionType
{

    /**
     * @var string
     */
    protected $readItems = null;

    /**
     * @var string
     */
    protected $permissionLevel = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getReadItems()
    {
        return $this->readItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PermissionType
     */
    public function setReadItems($value)
    {
        $this->readItems = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPermissionLevel()
    {
        return $this->permissionLevel;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PermissionType
     */
    public function setPermissionLevel($value)
    {
        $this->permissionLevel = $value;
        return $this;
    }
}
