<?php

namespace garethp\ews\API\Type;

/**
 * Class representing PostItemType
 *
 *
 * XSD Type: PostItemType
 */
class PostItemType extends ItemType
{

    /**
     * @var string
     */
    protected $conversationIndex = null;

    /**
     * @var string
     */
    protected $conversationTopic = null;

    /**
     * @var \garethp\ews\API\Type\SingleRecipientType
     */
    protected $from = null;

    /**
     * @var string
     */
    protected $internetMessageId = null;

    /**
     * @var boolean
     */
    protected $isRead = null;

    /**
     * @var \DateTime
     */
    protected $postedTime = null;

    /**
     * @var string
     */
    protected $references = null;

    /**
     * @var \garethp\ews\API\Type\SingleRecipientType
     */
    protected $sender = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getConversationIndex()
    {
        return $this->conversationIndex;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PostItemType
     */
    public function setConversationIndex($value)
    {
        $this->conversationIndex = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getConversationTopic()
    {
        return $this->conversationTopic;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PostItemType
     */
    public function setConversationTopic($value)
    {
        $this->conversationTopic = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SingleRecipientType
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SingleRecipientType
     * @return PostItemType
     */
    public function setFrom(SingleRecipientType $value)
    {
        $this->from = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getInternetMessageId()
    {
        return $this->internetMessageId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PostItemType
     */
    public function setInternetMessageId($value)
    {
        $this->internetMessageId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isRead()
    {
        return ((bool) $this->isRead);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsRead()
    {
        return $this->isRead;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return PostItemType
     */
    public function setIsRead($value)
    {
        $this->isRead = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getPostedTime()
    {
        return $this->postedTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return PostItemType
     */
    public function setPostedTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->postedTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getReferences()
    {
        return $this->references;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PostItemType
     */
    public function setReferences($value)
    {
        $this->references = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SingleRecipientType
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SingleRecipientType
     * @return PostItemType
     */
    public function setSender(SingleRecipientType $value)
    {
        $this->sender = $value;
        return $this;
    }
}
