<?php

namespace garethp\ews\API\Type;

/**
 * Class representing ProtectionRulesServiceConfigurationType
 *
 *
 * XSD Type: ProtectionRulesServiceConfiguration
 */
class ProtectionRulesServiceConfigurationType extends ServiceConfigurationType
{

    /**
     * @var integer
     */
    protected $refreshInterval = null;

    /**
     * @var \garethp\ews\API\Type\ProtectionRuleType[]
     */
    protected $rules = null;

    /**
     * @var \garethp\ews\API\Type\SmtpDomainType[]
     */
    protected $internalDomains = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getRefreshInterval()
    {
        return $this->refreshInterval;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ProtectionRulesServiceConfigurationType
     */
    public function setRefreshInterval($value)
    {
        $this->refreshInterval = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleType
     * @return ProtectionRulesServiceConfigurationType
     */
    public function addRules(ProtectionRuleType $value)
    {
        if ($this->rules === null) {
                        $this->rules = array();
        }

        if (!is_array($this->rules)) {
            $this->rules = array($this->rules);
        }

        $this->rules[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ProtectionRuleType[]
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleType[]|ProtectionRuleType
     * @return ProtectionRulesServiceConfigurationType
     */
    public function setRules(array|ProtectionRuleType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->rules = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmtpDomainType
     * @return ProtectionRulesServiceConfigurationType
     */
    public function addInternalDomains(SmtpDomainType $value)
    {
        if ($this->internalDomains === null) {
                        $this->internalDomains = array();
        }

        if (!is_array($this->internalDomains)) {
            $this->internalDomains = array($this->internalDomains);
        }

        $this->internalDomains[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SmtpDomainType[]
     */
    public function getInternalDomains()
    {
        return $this->internalDomains;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmtpDomainType[]|SmtpDomainType
     * @return ProtectionRulesServiceConfigurationType
     */
    public function setInternalDomains(array|SmtpDomainType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->internalDomains = $value;
        return $this;
    }
}
