<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing SerializableTimeZoneType
 *
 *
 * XSD Type: SerializableTimeZone
 */
class SerializableTimeZoneType extends Type
{

    /**
     * @var integer
     */
    protected $bias = null;

    /**
     * @var \garethp\ews\API\Type\SerializableTimeZoneTimeType
     */
    protected $standardTime = null;

    /**
     * @var \garethp\ews\API\Type\SerializableTimeZoneTimeType
     */
    protected $daylightTime = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getBias()
    {
        return $this->bias;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SerializableTimeZoneType
     */
    public function setBias($value)
    {
        $this->bias = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SerializableTimeZoneTimeType
     */
    public function getStandardTime()
    {
        return $this->standardTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SerializableTimeZoneTimeType
     * @return SerializableTimeZoneType
     */
    public function setStandardTime(SerializableTimeZoneTimeType $value)
    {
        $this->standardTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SerializableTimeZoneTimeType
     */
    public function getDaylightTime()
    {
        return $this->daylightTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SerializableTimeZoneTimeType
     * @return SerializableTimeZoneType
     */
    public function setDaylightTime(SerializableTimeZoneTimeType $value)
    {
        $this->daylightTime = $value;
        return $this;
    }
}
