<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing TaskRecurrenceType
 *
 *
 * XSD Type: TaskRecurrenceType
 */
class TaskRecurrenceType extends Type
{

    /**
     * @var \garethp\ews\API\Type\RelativeYearlyRecurrencePatternType
     */
    protected $relativeYearlyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\AbsoluteYearlyRecurrencePatternType
     */
    protected $absoluteYearlyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\RelativeMonthlyRecurrencePatternType
     */
    protected $relativeMonthlyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\AbsoluteMonthlyRecurrencePatternType
     */
    protected $absoluteMonthlyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\WeeklyRecurrencePatternType
     */
    protected $weeklyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\DailyRecurrencePatternType
     */
    protected $dailyRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\DailyRegeneratingPatternType
     */
    protected $dailyRegeneration = null;

    /**
     * @var \garethp\ews\API\Type\WeeklyRegeneratingPatternType
     */
    protected $weeklyRegeneration = null;

    /**
     * @var \garethp\ews\API\Type\MonthlyRegeneratingPatternType
     */
    protected $monthlyRegeneration = null;

    /**
     * @var \garethp\ews\API\Type\YearlyRegeneratingPatternType
     */
    protected $yearlyRegeneration = null;

    /**
     * @var \garethp\ews\API\Type\NoEndRecurrenceRangeType
     */
    protected $noEndRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\EndDateRecurrenceRangeType
     */
    protected $endDateRecurrence = null;

    /**
     * @var \garethp\ews\API\Type\NumberedRecurrenceRangeType
     */
    protected $numberedRecurrence = null;

    /**
     * @autogenerated This method is safe to replace
     * @return RelativeYearlyRecurrencePatternType
     */
    public function getRelativeYearlyRecurrence()
    {
        return $this->relativeYearlyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RelativeYearlyRecurrencePatternType
     * @return TaskRecurrenceType
     */
    public function setRelativeYearlyRecurrence(RelativeYearlyRecurrencePatternType $value)
    {
        $this->relativeYearlyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AbsoluteYearlyRecurrencePatternType
     */
    public function getAbsoluteYearlyRecurrence()
    {
        return $this->absoluteYearlyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AbsoluteYearlyRecurrencePatternType
     * @return TaskRecurrenceType
     */
    public function setAbsoluteYearlyRecurrence(AbsoluteYearlyRecurrencePatternType $value)
    {
        $this->absoluteYearlyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RelativeMonthlyRecurrencePatternType
     */
    public function getRelativeMonthlyRecurrence()
    {
        return $this->relativeMonthlyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RelativeMonthlyRecurrencePatternType
     * @return TaskRecurrenceType
     */
    public function setRelativeMonthlyRecurrence(RelativeMonthlyRecurrencePatternType $value)
    {
        $this->relativeMonthlyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AbsoluteMonthlyRecurrencePatternType
     */
    public function getAbsoluteMonthlyRecurrence()
    {
        return $this->absoluteMonthlyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AbsoluteMonthlyRecurrencePatternType
     * @return TaskRecurrenceType
     */
    public function setAbsoluteMonthlyRecurrence(AbsoluteMonthlyRecurrencePatternType $value)
    {
        $this->absoluteMonthlyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return WeeklyRecurrencePatternType
     */
    public function getWeeklyRecurrence()
    {
        return $this->weeklyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value WeeklyRecurrencePatternType
     * @return TaskRecurrenceType
     */
    public function setWeeklyRecurrence(WeeklyRecurrencePatternType $value)
    {
        $this->weeklyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DailyRecurrencePatternType
     */
    public function getDailyRecurrence()
    {
        return $this->dailyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IntervalRecurrencePatternBaseType
     * @return TaskRecurrenceType
     */
    public function setDailyRecurrence(IntervalRecurrencePatternBaseType $value)
    {
        $this->dailyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DailyRegeneratingPatternType
     */
    public function getDailyRegeneration()
    {
        return $this->dailyRegeneration;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IntervalRecurrencePatternBaseType
     * @return TaskRecurrenceType
     */
    public function setDailyRegeneration(IntervalRecurrencePatternBaseType $value)
    {
        $this->dailyRegeneration = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return WeeklyRegeneratingPatternType
     */
    public function getWeeklyRegeneration()
    {
        return $this->weeklyRegeneration;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IntervalRecurrencePatternBaseType
     * @return TaskRecurrenceType
     */
    public function setWeeklyRegeneration(IntervalRecurrencePatternBaseType $value)
    {
        $this->weeklyRegeneration = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MonthlyRegeneratingPatternType
     */
    public function getMonthlyRegeneration()
    {
        return $this->monthlyRegeneration;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IntervalRecurrencePatternBaseType
     * @return TaskRecurrenceType
     */
    public function setMonthlyRegeneration(IntervalRecurrencePatternBaseType $value)
    {
        $this->monthlyRegeneration = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return YearlyRegeneratingPatternType
     */
    public function getYearlyRegeneration()
    {
        return $this->yearlyRegeneration;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IntervalRecurrencePatternBaseType
     * @return TaskRecurrenceType
     */
    public function setYearlyRegeneration(IntervalRecurrencePatternBaseType $value)
    {
        $this->yearlyRegeneration = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NoEndRecurrenceRangeType
     */
    public function getNoEndRecurrence()
    {
        return $this->noEndRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurrenceRangeBaseType
     * @return TaskRecurrenceType
     */
    public function setNoEndRecurrence(RecurrenceRangeBaseType $value)
    {
        $this->noEndRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EndDateRecurrenceRangeType
     */
    public function getEndDateRecurrence()
    {
        return $this->endDateRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EndDateRecurrenceRangeType
     * @return TaskRecurrenceType
     */
    public function setEndDateRecurrence(EndDateRecurrenceRangeType $value)
    {
        $this->endDateRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NumberedRecurrenceRangeType
     */
    public function getNumberedRecurrence()
    {
        return $this->numberedRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NumberedRecurrenceRangeType
     * @return TaskRecurrenceType
     */
    public function setNumberedRecurrence(NumberedRecurrenceRangeType $value)
    {
        $this->numberedRecurrence = $value;
        return $this;
    }
}
