<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing TimeChangeType
 *
 *
 * XSD Type: TimeChangeType
 */
class TimeChangeType extends Type
{

    /**
     * @var string
     */
    protected $timeZoneName = null;

    /**
     * @var \DateInterval
     */
    protected $offset = null;

    /**
     * @var \garethp\ews\API\Type\RelativeYearlyRecurrencePatternType
     */
    protected $relativeYearlyRecurrence = null;

    /**
     * @var \DateTime
     */
    protected $absoluteDate = null;

    /**
     * @var \DateTime
     */
    protected $time = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getTimeZoneName()
    {
        return $this->timeZoneName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return TimeChangeType
     */
    public function setTimeZoneName($value)
    {
        $this->timeZoneName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateInterval
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateInterval|string
     * @return TimeChangeType
     */
    public function setOffset(\DateInterval|string $value)
    {
        if (is_string($value)) {
            $invert = false;
            if (str_starts_with($value, "-")) {
                $invert = true;
                $value = substr($value, 1);
            }
            $value = new \DateInterval($value);
            $value->invert = $invert;
        }

        $this->offset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RelativeYearlyRecurrencePatternType
     */
    public function getRelativeYearlyRecurrence()
    {
        return $this->relativeYearlyRecurrence;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RelativeYearlyRecurrencePatternType
     * @return TimeChangeType
     */
    public function setRelativeYearlyRecurrence(RelativeYearlyRecurrencePatternType $value)
    {
        $this->relativeYearlyRecurrence = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getAbsoluteDate()
    {
        return $this->absoluteDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return TimeChangeType
     */
    public function setAbsoluteDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->absoluteDate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return TimeChangeType
     */
    public function setTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->time = $value;
        return $this;
    }
}
