<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing WorkingPeriodType
 *
 *
 * XSD Type: WorkingPeriod
 */
class WorkingPeriodType extends Type
{

    /**
     * @var string[]
     */
    protected $dayOfWeek = null;

    /**
     * @var integer
     */
    protected $startTimeInMinutes = null;

    /**
     * @var integer
     */
    protected $endTimeInMinutes = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return WorkingPeriodType
     */
    public function addDayOfWeek($value)
    {
        if ($this->dayOfWeek === null) {
                        $this->dayOfWeek = array();
        }

        if (!is_array($this->dayOfWeek)) {
            $this->dayOfWeek = array($this->dayOfWeek);
        }

        $this->dayOfWeek[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getDayOfWeek()
    {
        return $this->dayOfWeek;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return WorkingPeriodType
     */
    public function setDayOfWeek(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->dayOfWeek = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getStartTimeInMinutes()
    {
        return $this->startTimeInMinutes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return WorkingPeriodType
     */
    public function setStartTimeInMinutes($value)
    {
        $this->startTimeInMinutes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getEndTimeInMinutes()
    {
        return $this->endTimeInMinutes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return WorkingPeriodType
     */
    public function setEndTimeInMinutes($value)
    {
        $this->endTimeInMinutes = $value;
        return $this;
    }
}
