/* parser generated by jison 0.4.6 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
var formula = (function(){
var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"expressions":3,"expression":4,"EOF":5,"variableSequence":6,"TIME_AMPM":7,"TIME_24":8,"number":9,"STRING":10,"&":11,"=":12,"+":13,"(":14,")":15,"<":16,">":17,"NOT":18,"-":19,"*":20,"/":21,"^":22,"E":23,"FUNCTION":24,"expseq":25,"cell":26,"FIXEDCELL":27,":":28,"CELL":29,"SHEET":30,"!":31,";":32,",":33,"VARIABLE":34,"DECIMAL":35,"NUMBER":36,"%":37,"#":38,"$accept":0,"$end":1},
terminals_: {5:"EOF",7:"TIME_AMPM",8:"TIME_24",10:"STRING",11:"&",12:"=",13:"+",14:"(",15:")",16:"<",17:">",18:"NOT",19:"-",20:"*",21:"/",22:"^",23:"E",24:"FUNCTION",27:"FIXEDCELL",28:":",29:"CELL",30:"SHEET",31:"!",32:";",33:",",34:"VARIABLE",35:"DECIMAL",36:"NUMBER",37:"%",38:"#"},
productions_: [0,[3,2],[4,1],[4,1],[4,1],[4,1],[4,1],[4,3],[4,3],[4,3],[4,3],[4,4],[4,4],[4,4],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,2],[4,2],[4,1],[4,3],[4,4],[4,1],[4,1],[4,2],[26,1],[26,3],[26,1],[26,3],[26,3],[26,5],[25,1],[25,3],[25,3],[6,1],[6,3],[9,1],[9,3],[9,2],[2,3],[2,4]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:
        return $$[$0-1];
    
break;
case 2:
        //js
		    this.$ = yy.handler.variable.apply(yy.obj, $$[$0]);

        /*php
            this.$ = this->variable($$[$0]);
        */
    
break;
case 3:
	    //js
            this.$ = yy.handler.time.call(yy.obj, $$[$0], true);
        //
    
break;
case 4:
        //js
            this.$ = yy.handler.time.call(yy.obj, $$[$0]);
        //

    
break;
case 5:
	    //js
            this.$ = yy.handler.number($$[$0]);

        /*php
            this.$ = $$[$0] * 1;
        */
    
break;
case 6:
        //js
            this.$ = $$[$0].substring(1, $$[$0].length - 1);
        /*php
	        this.$ = substr($$[$0], 1, -1);
        */
    
break;
case 7:
        //js
            this.$ = $$[$0-2].toString() + $$[$0].toString();

        /*php
            this.$ = $$[$0-2] . '' . $$[$0];
        */
    
break;
case 8:
	    //js
            this.$ = yy.handler.callFunction.call(yy.obj, 'EQUAL', [$$[$0-2], $$[$0]]);

        /*php
            this.$ = $$[$0-2] == $$[$0];
        */
    
break;
case 9:
	    //js
			this.$ = yy.handler.performMath('+', $$[$0-2], $$[$0]);

        /*php
			if (is_numeric($$[$0-2]) && is_numeric($$[$0])) {
			   this.$ = $$[$0-2] + $$[$0];
			} else {
			   this.$ = $$[$0-2] . $$[$0];
			}
        */
    
break;
case 10:
	    //js
	        this.$ = yy.handler.number($$[$0-1]);
        //
	
break;
case 11:
        //js
            this.$ = yy.handler.callFunction.call(yy.obj, 'LESS_EQUAL', [$$[$0-3], $$[$0-1]]);

        /*php
            this.$ = ($$[$0-3] * 1) <= ($$[$0] * 1);
        */
    
break;
case 12:
        //js
            this.$ = yy.handler.callFunction.call(yy.obj, 'GREATER_EQUAL', [$$[$0-3], $$[$0-1]]);

        /*php
            this.$ = ($$[$0-3] * 1) >= ($$[$0] * 1);
        */
    
break;
case 13:
        this.$ = ($$[$0-3]) != ($$[$0]);

        //js
			if (isNaN(this.$)) {
			    this.$ = 0;
			}
        //
    
break;
case 14:
        this.$ = $$[$0-2] != $$[$0];
    
break;
case 15:
	    //js
			this.$ = yy.handler.callFunction.call(yy.obj, 'GREATER', [$$[$0-2], $$[$0]]);

		/*php
		    this.$ = ($$[$0-2] * 1) > ($$[$0] * 1);
        */
    
break;
case 16:
        //js
            this.$ = yy.handler.callFunction.call(yy.obj, 'LESS', [$$[$0-2], $$[$0]]);

        /*php
            this.$ = ($$[$0-2] * 1) < ($$[$0] * 1);
        */
    
break;
case 17:
        //js
            this.$ = yy.handler.performMath('-', $$[$0-2], $$[$0]);

        /*php
            this.$ = ($$[$0-2] * 1) - ($$[$0] * 1);
        */
    
break;
case 18:
	    //js
            this.$ = yy.handler.performMath('*', $$[$0-2], $$[$0]);

        /*php
            this.$ = ($$[$0-2] * 1) * ($$[$0] * 1);
        */
    
break;
case 19:
	    //js
            this.$ = yy.handler.performMath('/', $$[$0-2], $$[$0]);

        /*php
            this.$ = ($$[$0-2] * 1) / ($$[$0] * 1);
        */
    
break;
case 20:
        //js
            var n1 = yy.handler.number($$[$0-2]),
                n2 = yy.handler.number($$[$0]);

            this.$ = yy.handler.performMath('^', $$[$0-2], $$[$0]);

        /*php
            this.$ = pow(($$[$0-2] * 1), ($$[$0] * 1));
        */
    
break;
case 21:
		//js
			var n1 = yy.handler.numberInverted($$[$0]);
			this.$ = n1;
			if (isNaN(this.$)) {
			    this.$ = 0;
			}

        /*php
            this.$ = $$[$0-1] * 1;
        */
		
break;
case 22:
	    //js
			var n1 = yy.handler.number($$[$0]);
			this.$ = n1;
			if (isNaN(this.$)) {
			    this.$ = 0;
			}

        /*php
            this.$ = $$[$0-1] * 1;
        */
		
break;
case 23:/*this.$ = Math.E;*/;
break;
case 24:
	    //js
			this.$ = yy.handler.callFunction.call(yy.obj, $$[$0-2], '');

		/*php
		    this.$ = this->callFunction($$[$0-2]);
        */
    
break;
case 25:
	    //js
			this.$ = yy.handler.callFunction.call(yy.obj, $$[$0-3], $$[$0-1]);

        /*php
            this.$ = this->callFunction($$[$0-3], $$[$0-1]);
        */
    
break;
case 29:
	    //js
			this.$ = yy.handler.fixedCellValue.call(yy.obj, $$[$0]);

        /*php
            this.$ = this->fixedCellValue($$[$0]);
        */
    
break;
case 30:
	    //js
           this.$ = yy.handler.fixedCellRangeValue.call(yy.obj, $$[$0-2], $$[$0]);

	    /*php
	        this.$ = this->fixedCellRangeValue($$[$0-2], $$[$0]);
        */
    
break;
case 31:
	    //js
			this.$ = yy.handler.cellValue.call(yy.obj, $$[$0]);
        /*php
            this.$ = this->cellValue($$[$0]);
        */
    
break;
case 32:
	    //js
			this.$ = yy.handler.cellRangeValue.call(yy.obj, $$[$0-2], $$[$0]);

        /*php
            this.$ = this->cellRangeValue($$[$0-2], $$[$0]);
        */
    
break;
case 33:
	    //js
			this.$ = yy.handler.remoteCellValue.call(yy.obj, $$[$0-2], $$[$0]);
        /*php
            this.$ = this->remoteCellValue($$[$0-2], $$[$0]);
        */
    
break;
case 34:
	    //js
            this.$ = yy.handler.remoteCellRangeValue.call(yy.obj, $$[$0-4], $$[$0-2], $$[$0]);

        /*php
            this.$ = this->remoteCellRangeValue($$[$0-4], $$[$0-2], $$[$0]);
        */
    
break;
case 35:
	    //js
            this.$ = [$$[$0]];

        /*php
            this.$ = array($$[$0]);
        */
    
break;
case 36:
	    //js
	        $$[$0-2].push($$[$0]);
	        this.$ = $$[$0-2];

        /*php
            $$[$0-2][] = $$[$0];
            this.$ = $$[$0-2];
        */
    
break;
case 37:
 	    //js
	        $$[$0-2].push($$[$0]);
	        this.$ = $$[$0-2];

        /*php
			$$[$0-2][] = $$[$0];
			this.$ = $$[$0-2];
        */
    
break;
case 38:
        this.$ = [$$[$0]];
    
break;
case 39:
        //js
            this.$ = ($.isArray($$[$0-2]) ? $$[$0-2] : [$$[$0-2]]);
            this.$.push($$[$0]);

        /*php
            this.$ = (is_array($$[$0-2]) ? $$[$0-2] : array());
            this.$[] = $$[$0];
        */
    
break;
case 40:
        this.$ = $$[$0];
    
break;
case 41:
        //js
            this.$ = ($$[$0-2] + '.' + $$[$0]) * 1;

        /*php
            this.$ = $$[$0-2] . '.' . $$[$0];
        */
    
break;
case 42:
        this.$ = $$[$0-1] * 0.01;
    
break;
case 43:
        this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
    
break;
case 44:
        this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
    
break;
}
},
table: [{2:14,3:1,4:2,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{1:[3]},{5:[1,21],11:[1,22],12:[1,23],13:[1,24],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31]},{5:[2,2],11:[2,2],12:[2,2],13:[2,2],15:[2,2],16:[2,2],17:[2,2],18:[2,2],19:[2,2],20:[2,2],21:[2,2],22:[2,2],32:[2,2],33:[2,2],35:[1,32]},{5:[2,3],11:[2,3],12:[2,3],13:[2,3],15:[2,3],16:[2,3],17:[2,3],18:[2,3],19:[2,3],20:[2,3],21:[2,3],22:[2,3],32:[2,3],33:[2,3]},{5:[2,4],11:[2,4],12:[2,4],13:[2,4],15:[2,4],16:[2,4],17:[2,4],18:[2,4],19:[2,4],20:[2,4],21:[2,4],22:[2,4],32:[2,4],33:[2,4]},{5:[2,5],11:[2,5],12:[2,5],13:[2,5],15:[2,5],16:[2,5],17:[2,5],18:[2,5],19:[2,5],20:[2,5],21:[2,5],22:[2,5],32:[2,5],33:[2,5],37:[1,33]},{5:[2,6],11:[2,6],12:[2,6],13:[2,6],15:[2,6],16:[2,6],17:[2,6],18:[2,6],19:[2,6],20:[2,6],21:[2,6],22:[2,6],32:[2,6],33:[2,6]},{2:14,4:34,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:35,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:36,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{5:[2,23],11:[2,23],12:[2,23],13:[2,23],15:[2,23],16:[2,23],17:[2,23],18:[2,23],19:[2,23],20:[2,23],21:[2,23],22:[2,23],32:[2,23],33:[2,23]},{14:[1,37]},{5:[2,26],11:[2,26],12:[2,26],13:[2,26],15:[2,26],16:[2,26],17:[2,26],18:[2,26],19:[2,26],20:[2,26],21:[2,26],22:[2,26],32:[2,26],33:[2,26]},{2:38,5:[2,27],11:[2,27],12:[2,27],13:[2,27],15:[2,27],16:[2,27],17:[2,27],18:[2,27],19:[2,27],20:[2,27],21:[2,27],22:[2,27],32:[2,27],33:[2,27],34:[1,39],38:[1,20]},{5:[2,38],11:[2,38],12:[2,38],13:[2,38],15:[2,38],16:[2,38],17:[2,38],18:[2,38],19:[2,38],20:[2,38],21:[2,38],22:[2,38],32:[2,38],33:[2,38],35:[2,38],38:[1,40]},{5:[2,40],11:[2,40],12:[2,40],13:[2,40],15:[2,40],16:[2,40],17:[2,40],18:[2,40],19:[2,40],20:[2,40],21:[2,40],22:[2,40],32:[2,40],33:[2,40],35:[1,41],37:[2,40]},{5:[2,29],11:[2,29],12:[2,29],13:[2,29],15:[2,29],16:[2,29],17:[2,29],18:[2,29],19:[2,29],20:[2,29],21:[2,29],22:[2,29],28:[1,42],32:[2,29],33:[2,29]},{5:[2,31],11:[2,31],12:[2,31],13:[2,31],15:[2,31],16:[2,31],17:[2,31],18:[2,31],19:[2,31],20:[2,31],21:[2,31],22:[2,31],28:[1,43],32:[2,31],33:[2,31]},{31:[1,44]},{34:[1,45]},{1:[2,1]},{2:14,4:46,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:47,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:48,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:51,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],12:[1,49],13:[1,10],14:[1,8],17:[1,50],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:53,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],12:[1,52],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:54,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:55,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:56,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:57,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:58,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{34:[1,59]},{5:[2,42],11:[2,42],12:[2,42],13:[2,42],15:[2,42],16:[2,42],17:[2,42],18:[2,42],19:[2,42],20:[2,42],21:[2,42],22:[2,42],32:[2,42],33:[2,42],37:[2,42]},{11:[1,22],12:[1,23],13:[1,24],15:[1,60],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31]},{5:[2,21],11:[1,22],12:[2,21],13:[2,21],15:[2,21],16:[2,21],17:[2,21],18:[2,21],19:[2,21],20:[1,29],21:[1,30],22:[1,31],32:[2,21],33:[2,21]},{5:[2,22],11:[1,22],12:[2,22],13:[2,22],15:[2,22],16:[2,22],17:[2,22],18:[2,22],19:[2,22],20:[1,29],21:[1,30],22:[1,31],32:[2,22],33:[2,22]},{2:14,4:63,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],15:[1,61],19:[1,9],23:[1,11],24:[1,12],25:62,26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{5:[2,28],11:[2,28],12:[2,28],13:[2,28],15:[2,28],16:[2,28],17:[2,28],18:[2,28],19:[2,28],20:[2,28],21:[2,28],22:[2,28],32:[2,28],33:[2,28]},{38:[1,40]},{34:[1,64]},{36:[1,65]},{27:[1,66]},{29:[1,67]},{29:[1,68]},{31:[1,69]},{5:[2,7],11:[1,22],12:[1,23],13:[1,24],15:[2,7],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,7],33:[2,7]},{5:[2,8],11:[1,22],12:[2,8],13:[1,24],15:[2,8],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,8],33:[2,8]},{5:[2,9],11:[1,22],12:[2,9],13:[2,9],15:[2,9],16:[2,9],17:[2,9],18:[2,9],19:[2,9],20:[1,29],21:[1,30],22:[1,31],32:[2,9],33:[2,9]},{2:14,4:70,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:71,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{5:[2,16],11:[1,22],12:[2,16],13:[1,24],15:[2,16],16:[2,16],17:[2,16],18:[2,16],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,16],33:[2,16]},{2:14,4:72,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{5:[2,15],11:[1,22],12:[2,15],13:[1,24],15:[2,15],16:[2,15],17:[2,15],18:[2,15],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,15],33:[2,15]},{5:[2,14],11:[1,22],12:[2,14],13:[1,24],15:[2,14],16:[1,25],17:[1,26],18:[2,14],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,14],33:[2,14]},{5:[2,17],11:[1,22],12:[2,17],13:[2,17],15:[2,17],16:[2,17],17:[2,17],18:[2,17],19:[2,17],20:[1,29],21:[1,30],22:[1,31],32:[2,17],33:[2,17]},{5:[2,18],11:[1,22],12:[2,18],13:[2,18],15:[2,18],16:[2,18],17:[2,18],18:[2,18],19:[2,18],20:[2,18],21:[2,18],22:[1,31],32:[2,18],33:[2,18]},{5:[2,19],11:[1,22],12:[2,19],13:[2,19],15:[2,19],16:[2,19],17:[2,19],18:[2,19],19:[2,19],20:[2,19],21:[2,19],22:[1,31],32:[2,19],33:[2,19]},{5:[2,20],11:[1,22],12:[2,20],13:[2,20],15:[2,20],16:[2,20],17:[2,20],18:[2,20],19:[2,20],20:[2,20],21:[2,20],22:[2,20],32:[2,20],33:[2,20]},{5:[2,39],11:[2,39],12:[2,39],13:[2,39],15:[2,39],16:[2,39],17:[2,39],18:[2,39],19:[2,39],20:[2,39],21:[2,39],22:[2,39],32:[2,39],33:[2,39],35:[2,39]},{5:[2,10],11:[2,10],12:[2,10],13:[2,10],15:[2,10],16:[2,10],17:[2,10],18:[2,10],19:[2,10],20:[2,10],21:[2,10],22:[2,10],32:[2,10],33:[2,10]},{5:[2,24],11:[2,24],12:[2,24],13:[2,24],15:[2,24],16:[2,24],17:[2,24],18:[2,24],19:[2,24],20:[2,24],21:[2,24],22:[2,24],32:[2,24],33:[2,24]},{15:[1,73],32:[1,74],33:[1,75]},{11:[1,22],12:[1,23],13:[1,24],15:[2,35],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,35],33:[2,35]},{31:[1,76]},{5:[2,41],11:[2,41],12:[2,41],13:[2,41],15:[2,41],16:[2,41],17:[2,41],18:[2,41],19:[2,41],20:[2,41],21:[2,41],22:[2,41],32:[2,41],33:[2,41],37:[2,41]},{5:[2,30],11:[2,30],12:[2,30],13:[2,30],15:[2,30],16:[2,30],17:[2,30],18:[2,30],19:[2,30],20:[2,30],21:[2,30],22:[2,30],32:[2,30],33:[2,30]},{5:[2,32],11:[2,32],12:[2,32],13:[2,32],15:[2,32],16:[2,32],17:[2,32],18:[2,32],19:[2,32],20:[2,32],21:[2,32],22:[2,32],32:[2,32],33:[2,32]},{5:[2,33],11:[2,33],12:[2,33],13:[2,33],15:[2,33],16:[2,33],17:[2,33],18:[2,33],19:[2,33],20:[2,33],21:[2,33],22:[2,33],28:[1,77],32:[2,33],33:[2,33]},{5:[2,43],11:[2,43],12:[2,43],13:[2,43],15:[2,43],16:[2,43],17:[2,43],18:[2,43],19:[2,43],20:[2,43],21:[2,43],22:[2,43],32:[2,43],33:[2,43],34:[2,43],38:[2,43]},{5:[2,11],11:[1,22],12:[2,11],13:[1,24],15:[2,11],16:[2,11],17:[2,11],18:[2,11],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,11],33:[2,11]},{5:[2,13],11:[1,22],12:[2,13],13:[1,24],15:[2,13],16:[2,13],17:[2,13],18:[2,13],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,13],33:[2,13]},{5:[2,12],11:[1,22],12:[2,12],13:[1,24],15:[2,12],16:[2,12],17:[2,12],18:[2,12],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,12],33:[2,12]},{5:[2,25],11:[2,25],12:[2,25],13:[2,25],15:[2,25],16:[2,25],17:[2,25],18:[2,25],19:[2,25],20:[2,25],21:[2,25],22:[2,25],32:[2,25],33:[2,25]},{2:14,4:78,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{2:14,4:79,6:3,7:[1,4],8:[1,5],9:6,10:[1,7],13:[1,10],14:[1,8],19:[1,9],23:[1,11],24:[1,12],26:13,27:[1,17],29:[1,18],30:[1,19],34:[1,15],36:[1,16],38:[1,20]},{5:[2,44],11:[2,44],12:[2,44],13:[2,44],15:[2,44],16:[2,44],17:[2,44],18:[2,44],19:[2,44],20:[2,44],21:[2,44],22:[2,44],32:[2,44],33:[2,44],34:[2,44],38:[2,44]},{29:[1,80]},{11:[1,22],12:[1,23],13:[1,24],15:[2,36],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,36],33:[2,36]},{11:[1,22],12:[1,23],13:[1,24],15:[2,37],16:[1,25],17:[1,26],18:[1,27],19:[1,28],20:[1,29],21:[1,30],22:[1,31],32:[2,37],33:[2,37]},{5:[2,34],11:[2,34],12:[2,34],13:[2,34],15:[2,34],16:[2,34],17:[2,34],18:[2,34],19:[2,34],20:[2,34],21:[2,34],22:[2,34],32:[2,34],33:[2,34]}],
defaultActions: {21:[2,1]},
parseError: function parseError(str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        throw new Error(str);
    }
},
parse: function parse(input) {
    var self = this,
        stack = [0],
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    //this.reductionCount = this.shiftCount = 0;

    this.lexer.setInput(input);
    this.lexer.yy = this.yy;
    this.yy.lexer = this.lexer;
    this.yy.parser = this;
    if (typeof this.lexer.yylloc == 'undefined') {
        this.lexer.yylloc = {};
    }
    var yyloc = this.lexer.yylloc;
    lstack.push(yyloc);

    var ranges = this.lexer.options && this.lexer.options.ranges;

    if (typeof this.yy.parseError === 'function') {
        this.parseError = this.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError; // because in the generated code 'this.__proto__.parseError' doesn't work for everyone: http://javascriptweblog.wordpress.com/2010/06/07/understanding-javascript-prototypes/
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

    function lex() {
        var token;
        token = self.lexer.lex() || EOF; // $end = 1
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (this.lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
						text: this.lexer.match,
						token: this.terminals_[symbol] || symbol,
						line: this.lexer.yylineno,
						loc: yyloc,
						expected: expected,
                        recoverable: (error_rule_depth !== false)
				});
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = this.lexer.yyleng;
                yytext = this.lexer.yytext;
                yylineno = this.lexer.yylineno;
                yyloc = this.lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(this.lexer.yytext);
                lstack.push(this.lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};

if (typeof(window) !== 'undefined') {
	window.Formula = function(handler) {
		var formulaLexer = function () {};
		formulaLexer.prototype = formula.lexer;

		var formulaParser = function () {
			this.lexer = new formulaLexer();
			this.yy = {};
		};

		formulaParser.prototype = formula;
		var newParser = new formulaParser;
		newParser.setObj = function(obj) {
			newParser.yy.obj = obj;
		};
		newParser.yy.handler = handler;
		return newParser;
	};
}/* generated by jison-lex 0.2.1 */
var lexer = (function(){
var lexer = {

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input) {
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len - 1);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function (match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex() {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState(condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {

var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0:/* skip whitespace */
break;
case 1:return 10;
break;
case 2:return 10;
break;
case 3:return 24;
break;
case 4:return 7;
break;
case 5:return 8;
break;
case 6:
	if (yy.obj.type == 'cell') return 30;//js
	return 34;//js

	//php if ($this->type == 'cell') return 30;
	//php return 34;

break;
case 7:
	if (yy.obj.type == 'cell') return 27;//js
	return 34;//js

	//php if ($this->type == 'cell') return 27;
    //php return 34;

break;
case 8:
	if (yy.obj.type == 'cell') return 29;//js
	return 34;//js

	//php if ($this->type == 'cell') return 29;
    //php return 34;

break;
case 9:return 24;
break;
case 10:return 34;
break;
case 11:return 34;
break;
case 12:return 36;
break;
case 13:/* skip whitespace */
break;
case 14:return 11;
break;
case 15:return ' ';
break;
case 16:return 35;
break;
case 17:return 28;
break;
case 18:return 32;
break;
case 19:return 33;
break;
case 20:return 20;
break;
case 21:return 21;
break;
case 22:return 19;
break;
case 23:return 13;
break;
case 24:return 22;
break;
case 25:return 14;
break;
case 26:return 15;
break;
case 27:return 17;
break;
case 28:return 16;
break;
case 29:return 18;
break;
case 30:return 'PI';
break;
case 31:return 23;
break;
case 32:return '"';
break;
case 33:return "'";
break;
case 34:return "!";
break;
case 35:return 12;
break;
case 36:return 37;
break;
case 37:return 38;
break;
case 38:return 5;
break;
}
},
rules: [/^(?:\s+)/,/^(?:"(\\["]|[^"])*")/,/^(?:'(\\[']|[^'])*')/,/^(?:[A-Za-z]{1,}[A-Za-z_0-9]+(?=[(]))/,/^(?:([0]?[1-9]|1[0-2])[:][0-5][0-9]([:][0-5][0-9])?[ ]?(AM|am|aM|Am|PM|pm|pM|Pm))/,/^(?:([0]?[0-9]|1[0-9]|2[0-3])[:][0-5][0-9]([:][0-5][0-9])?)/,/^(?:SHEET[0-9]+)/,/^(?:\$[A-Za-z]+\$[0-9]+)/,/^(?:[A-Za-z]+[0-9]+)/,/^(?:[A-Za-z]+(?=[(]))/,/^(?:[A-Za-z]{1,}[A-Za-z_0-9]+)/,/^(?:[A-Za-z_]+)/,/^(?:[0-9]+)/,/^(?:\$)/,/^(?:&)/,/^(?: )/,/^(?:[.])/,/^(?::)/,/^(?:;)/,/^(?:,)/,/^(?:\*)/,/^(?:\/)/,/^(?:-)/,/^(?:\+)/,/^(?:\^)/,/^(?:\()/,/^(?:\))/,/^(?:>)/,/^(?:<)/,/^(?:NOT\b)/,/^(?:PI\b)/,/^(?:E\b)/,/^(?:")/,/^(?:')/,/^(?:!)/,/^(?:=)/,/^(?:%)/,/^(?:[#])/,/^(?:$)/],
conditions: {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38],"inclusive":true}}
};
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();


if (typeof require !== 'undefined' && typeof exports !== 'undefined') {
exports.parser = formula;
exports.Parser = formula.Parser;
exports.parse = function () { return formula.parse.apply(formula, arguments); };
exports.main = function commonjsMain(args) {
    if (!args[1]) {
        console.log('Usage: '+args[0]+' FILE');
        process.exit(1);
    }
    var source = require('fs').readFileSync(require('path').normalize(args[1]), "utf8");
    return exports.parser.parse(source);
};
if (typeof module !== 'undefined' && require.main === module) {
  exports.main(process.argv.slice(1));
}
}