<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platforms allow them to do with
// text.
//
// Copyright (C) 2006-2023  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Plugin\Reach\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
abstract class EntryVendorTaskBaseFilter extends \Kaltura\Client\Type\RelatedFilter
{
	public function getKalturaObjectType()
	{
		return 'KalturaEntryVendorTaskBaseFilter';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->idEqual))
			$this->idEqual = (string)$xml->idEqual;
		if(count($xml->idIn))
			$this->idIn = (string)$xml->idIn;
		if(count($xml->idNotIn))
			$this->idNotIn = (string)$xml->idNotIn;
		if(count($xml->vendorPartnerIdEqual))
			$this->vendorPartnerIdEqual = (int)$xml->vendorPartnerIdEqual;
		if(count($xml->vendorPartnerIdIn))
			$this->vendorPartnerIdIn = (string)$xml->vendorPartnerIdIn;
		if(count($xml->createdAtGreaterThanOrEqual))
			$this->createdAtGreaterThanOrEqual = (int)$xml->createdAtGreaterThanOrEqual;
		if(count($xml->createdAtLessThanOrEqual))
			$this->createdAtLessThanOrEqual = (int)$xml->createdAtLessThanOrEqual;
		if(count($xml->updatedAtGreaterThanOrEqual))
			$this->updatedAtGreaterThanOrEqual = (int)$xml->updatedAtGreaterThanOrEqual;
		if(count($xml->updatedAtLessThanOrEqual))
			$this->updatedAtLessThanOrEqual = (int)$xml->updatedAtLessThanOrEqual;
		if(count($xml->queueTimeGreaterThanOrEqual))
			$this->queueTimeGreaterThanOrEqual = (int)$xml->queueTimeGreaterThanOrEqual;
		if(count($xml->queueTimeLessThanOrEqual))
			$this->queueTimeLessThanOrEqual = (int)$xml->queueTimeLessThanOrEqual;
		if(count($xml->finishTimeGreaterThanOrEqual))
			$this->finishTimeGreaterThanOrEqual = (int)$xml->finishTimeGreaterThanOrEqual;
		if(count($xml->finishTimeLessThanOrEqual))
			$this->finishTimeLessThanOrEqual = (int)$xml->finishTimeLessThanOrEqual;
		if(count($xml->entryIdEqual))
			$this->entryIdEqual = (string)$xml->entryIdEqual;
		if(count($xml->statusEqual))
			$this->statusEqual = (int)$xml->statusEqual;
		if(count($xml->statusIn))
			$this->statusIn = (string)$xml->statusIn;
		if(count($xml->reachProfileIdEqual))
			$this->reachProfileIdEqual = (int)$xml->reachProfileIdEqual;
		if(count($xml->reachProfileIdIn))
			$this->reachProfileIdIn = (string)$xml->reachProfileIdIn;
		if(count($xml->catalogItemIdEqual))
			$this->catalogItemIdEqual = (int)$xml->catalogItemIdEqual;
		if(count($xml->catalogItemIdIn))
			$this->catalogItemIdIn = (string)$xml->catalogItemIdIn;
		if(count($xml->userIdEqual))
			$this->userIdEqual = (string)$xml->userIdEqual;
		if(count($xml->contextEqual))
			$this->contextEqual = (string)$xml->contextEqual;
		if(count($xml->expectedFinishTimeGreaterThanOrEqual))
			$this->expectedFinishTimeGreaterThanOrEqual = (int)$xml->expectedFinishTimeGreaterThanOrEqual;
		if(count($xml->expectedFinishTimeLessThanOrEqual))
			$this->expectedFinishTimeLessThanOrEqual = (int)$xml->expectedFinishTimeLessThanOrEqual;
		if(count($xml->entryObjectTypeEqual))
			$this->entryObjectTypeEqual = (int)$xml->entryObjectTypeEqual;
		if(count($xml->entryObjectTypeIn))
			$this->entryObjectTypeIn = (string)$xml->entryObjectTypeIn;
		if(count($xml->entryObjectTypeNotIn))
			$this->entryObjectTypeNotIn = (string)$xml->entryObjectTypeNotIn;
	}
	/**
	 * 
	 * @var int
	 */
	public $idEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $idIn = null;

	/**
	 * 
	 * @var string
	 */
	public $idNotIn = null;

	/**
	 * 
	 * @var int
	 */
	public $vendorPartnerIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $vendorPartnerIdIn = null;

	/**
	 * 
	 * @var int
	 */
	public $createdAtGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $createdAtLessThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $updatedAtGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $updatedAtLessThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $queueTimeGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $queueTimeLessThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $finishTimeGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $finishTimeLessThanOrEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $entryIdEqual = null;

	/**
	 * 
	 * @var \Kaltura\Client\Plugin\Reach\Enum\EntryVendorTaskStatus
	 */
	public $statusEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $statusIn = null;

	/**
	 * 
	 * @var int
	 */
	public $reachProfileIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $reachProfileIdIn = null;

	/**
	 * 
	 * @var int
	 */
	public $catalogItemIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $catalogItemIdIn = null;

	/**
	 * 
	 * @var string
	 */
	public $userIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $contextEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $expectedFinishTimeGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $expectedFinishTimeLessThanOrEqual = null;

	/**
	 * 
	 * @var \Kaltura\Client\Plugin\Reach\Enum\EntryObjectType
	 */
	public $entryObjectTypeEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $entryObjectTypeIn = null;

	/**
	 * 
	 * @var string
	 */
	public $entryObjectTypeNotIn = null;

}
